/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.common.ISE;
import io.druid.jackson.DefaultObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class Utils {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    public static OutputStream makePathAndOutputStream(JobContext job, Path outputPath, boolean deleteExisting) throws IOException {
        FileSystem fs = outputPath.getFileSystem(job.getConfiguration());
        CompressionCodec codec = null;
        if (FileOutputFormat.getCompressOutput((JobContext)job)) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
            outputPath = new Path(outputPath.toString() + codec.getDefaultExtension());
        }
        if (fs.exists(outputPath)) {
            if (deleteExisting) {
                fs.delete(outputPath, false);
            } else {
                throw new ISE("outputPath[%s] must not exist.", new Object[]{outputPath});
            }
        }
        Object retVal = FileOutputFormat.getCompressOutput((JobContext)job) ? codec.createOutputStream((OutputStream)fs.create(outputPath, false)) : fs.create(outputPath, false);
        return retVal;
    }

    public static InputStream openInputStream(JobContext job, Path inputPath) throws IOException {
        return Utils.openInputStream(job, inputPath, inputPath.getFileSystem(job.getConfiguration()));
    }

    public static boolean exists(JobContext job, FileSystem fs, Path inputPath) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fs.exists(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        return fs.exists(new Path(inputPath.toString() + codec.getDefaultExtension()));
    }

    public static InputStream openInputStream(JobContext job, Path inputPath, FileSystem fileSystem) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fileSystem.open(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        inputPath = new Path(inputPath.toString() + codec.getDefaultExtension());
        return codec.createInputStream((InputStream)fileSystem.open(inputPath));
    }

    public static Map<String, Object> getStats(JobContext job, Path statsPath) throws IOException {
        FileSystem fs = statsPath.getFileSystem(job.getConfiguration());
        return (Map)jsonMapper.readValue((InputStream)fs.open(statsPath), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static void storeStats(JobContext job, Path path, Map<String, Object> stats) throws IOException {
        jsonMapper.writeValue(Utils.makePathAndOutputStream(job, path, true), stats);
    }
}

