/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.hadoop;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import io.druid.collections.CountingMap;
import io.druid.data.input.InputRow;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.JobHelper;
import io.druid.indexer.hadoop.DatasourceInputSplit;
import io.druid.indexer.hadoop.DatasourceRecordReader;
import io.druid.indexer.hadoop.WindowedDataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DatasourceInputFormat
extends InputFormat<NullWritable, InputRow> {
    private static final Logger logger = new Logger(DatasourceInputFormat.class);
    public static final String CONF_INPUT_SEGMENTS = "druid.segments";
    public static final String CONF_DRUID_SCHEMA = "druid.datasource.schema";
    public static final String CONF_MAX_SPLIT_SIZE = "druid.datasource.split.max.size";
    private Supplier<org.apache.hadoop.mapred.InputFormat> supplier = new Supplier<org.apache.hadoop.mapred.InputFormat>(){

        public org.apache.hadoop.mapred.InputFormat get() {
            return new TextInputFormat(){

                protected boolean isSplitable(FileSystem fs, Path file) {
                    return false;
                }
            };
        }
    };

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String segmentsStr = (String)Preconditions.checkNotNull((Object)conf.get(CONF_INPUT_SEGMENTS), (Object)"No segments found to read");
        List segments = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(segmentsStr, (TypeReference)new TypeReference<List<WindowedDataSegment>>(){});
        if (segments == null || segments.size() == 0) {
            throw new ISE("No segments found to read", new Object[0]);
        }
        logger.info("segments to read [%s]", new Object[]{segmentsStr});
        long maxSize = conf.getLong(CONF_MAX_SPLIT_SIZE, 0L);
        if (maxSize > 0L) {
            Collections.sort(segments, new Comparator<WindowedDataSegment>(){

                @Override
                public int compare(WindowedDataSegment s1, WindowedDataSegment s2) {
                    return Long.compare(s1.getSegment().getSize(), s2.getSegment().getSize());
                }
            });
        }
        ArrayList splits = Lists.newArrayList();
        ArrayList list = new ArrayList();
        long size = 0L;
        JobConf dummyConf = new JobConf();
        org.apache.hadoop.mapred.InputFormat fio = (org.apache.hadoop.mapred.InputFormat)this.supplier.get();
        for (WindowedDataSegment segment : segments) {
            if (size + segment.getSegment().getSize() > maxSize && size > 0L) {
                splits.add(this.toDataSourceSplit(list, fio, dummyConf));
                list = Lists.newArrayList();
                size = 0L;
            }
            list.add((WindowedDataSegment)segment);
            size += segment.getSegment().getSize();
        }
        if (list.size() > 0) {
            splits.add(this.toDataSourceSplit(list, fio, dummyConf));
        }
        logger.info("Number of splits [%d]", new Object[]{splits.size()});
        return splits;
    }

    public RecordReader<NullWritable, InputRow> createRecordReader(org.apache.hadoop.mapreduce.InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new DatasourceRecordReader();
    }

    @VisibleForTesting
    DatasourceInputFormat setSupplier(Supplier<org.apache.hadoop.mapred.InputFormat> supplier) {
        this.supplier = supplier;
        return this;
    }

    private DatasourceInputSplit toDataSourceSplit(List<WindowedDataSegment> segments, org.apache.hadoop.mapred.InputFormat fio, JobConf conf) {
        String[] locations = null;
        try {
            locations = this.getFrequentLocations(segments, fio, conf);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Exception thrown finding location of splits", new Object[0]);
        }
        return new DatasourceInputSplit(segments, locations);
    }

    private String[] getFrequentLocations(List<WindowedDataSegment> segments, org.apache.hadoop.mapred.InputFormat fio, JobConf conf) throws IOException {
        Iterable<String> locations = Collections.emptyList();
        for (WindowedDataSegment segment : segments) {
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(JobHelper.getURIFromSegment(segment.getSegment()))});
            for (InputSplit split : fio.getSplits(conf, 1)) {
                locations = Iterables.concat(locations, Arrays.asList(split.getLocations()));
            }
        }
        return DatasourceInputFormat.getFrequentLocations(locations);
    }

    private static String[] getFrequentLocations(Iterable<String> hosts) {
        CountingMap counter = new CountingMap();
        for (String string : hosts) {
            counter.add((Object)string, 1L);
        }
        TreeSet sorted = Sets.newTreeSet((Comparator)new Comparator<Pair<Long, String>>(){

            @Override
            public int compare(Pair<Long, String> o1, Pair<Long, String> o2) {
                int compare = ((Long)o2.lhs).compareTo((Long)o1.lhs);
                if (compare == 0) {
                    compare = ((String)o1.rhs).compareTo((String)o2.rhs);
                }
                return compare;
            }
        });
        for (Map.Entry entry : counter.entrySet()) {
            sorted.add(Pair.of((Object)((AtomicLong)entry.getValue()).get(), entry.getKey()));
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)3);
        for (Pair frequent : Iterables.limit((Iterable)sorted, (int)3)) {
            arrayList.add(frequent.rhs);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

