/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.Granularity;
import com.metamx.common.guava.Comparators;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.hadoop.FSSpideringIterator;
import io.druid.indexer.path.GranularityPathSpec;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GranularUnprocessedPathSpec
extends GranularityPathSpec {
    private int maxBuckets;

    @JsonProperty
    public int getMaxBuckets() {
        return this.maxBuckets;
    }

    public void setMaxBuckets(int maxBuckets) {
        this.maxBuckets = maxBuckets;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        long mTime;
        Preconditions.checkState((boolean)(config.getGranularitySpec() instanceof UniformGranularitySpec), (Object)String.format("Cannot use %s without %s", GranularUnprocessedPathSpec.class.getSimpleName(), UniformGranularitySpec.class.getSimpleName()));
        Path betaInput = new Path(this.getInputPath());
        FileSystem fs = betaInput.getFileSystem(job.getConfiguration());
        Granularity segmentGranularity = config.getGranularitySpec().getSegmentGranularity();
        TreeMap<DateTime, Long> inputModifiedTimes = new TreeMap<DateTime, Long>(Comparators.inverse((Comparator)Comparators.comparable()));
        for (FileStatus status : FSSpideringIterator.spiderIterable(fs, betaInput)) {
            DateTime key = segmentGranularity.toDate(status.getPath().toString());
            Long currVal = (Long)inputModifiedTimes.get(key);
            mTime = status.getModificationTime();
            inputModifiedTimes.put(key, currVal == null ? mTime : Math.max(currVal, mTime));
        }
        TreeSet bucketsToRun = Sets.newTreeSet((Comparator)Comparators.intervals());
        for (Map.Entry entry : inputModifiedTimes.entrySet()) {
            DateTime timeBucket = (DateTime)entry.getKey();
            mTime = (Long)entry.getValue();
            String bucketOutput = String.format("%s/%s", config.getSchema().getIOConfig().getSegmentOutputPath(), segmentGranularity.toPath(timeBucket));
            for (FileStatus fileStatus : FSSpideringIterator.spiderIterable(fs, new Path(bucketOutput))) {
                if (fileStatus.getModificationTime() <= mTime) continue;
                bucketsToRun.add(new Interval((ReadableInstant)timeBucket, (ReadableInstant)segmentGranularity.increment(timeBucket)));
                break;
            }
            if (bucketsToRun.size() < this.maxBuckets) continue;
            break;
        }
        config.setGranularitySpec((GranularitySpec)new UniformGranularitySpec(segmentGranularity, config.getGranularitySpec().getQueryGranularity(), (List)Lists.newArrayList((Iterable)bucketsToRun)));
        return super.addInputPaths(config, job);
    }
}

