/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DataTransferProtoUtil {
    static BlockConstructionStage fromProto(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage stage) {
        return BlockConstructionStage.valueOf(stage.name());
    }

    static DataTransferProtos.OpWriteBlockProto.BlockConstructionStage toProto(BlockConstructionStage stage) {
        return DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf(stage.name());
    }

    public static DataTransferProtos.ChecksumProto toProto(DataChecksum checksum) {
        HdfsProtos.ChecksumTypeProto type = PBHelper.convert(checksum.getChecksumType());
        return DataTransferProtos.ChecksumProto.newBuilder().setBytesPerChecksum(checksum.getBytesPerChecksum()).setType(type).build();
    }

    public static DataChecksum fromProto(DataTransferProtos.ChecksumProto proto) {
        if (proto == null) {
            return null;
        }
        int bytesPerChecksum = proto.getBytesPerChecksum();
        DataChecksum.Type type = PBHelper.convert(proto.getType());
        return DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)bytesPerChecksum);
    }

    static DataTransferProtos.ClientOperationHeaderProto buildClientHeader(ExtendedBlock blk, String client, Token<BlockTokenIdentifier> blockToken) {
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setClientName(client).build();
        return header;
    }

    static DataTransferProtos.BaseHeaderProto buildBaseHeader(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) {
        return DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelper.convert(blk)).setToken(PBHelper.convert(blockToken)).build();
    }
}

