/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResetDBClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBClusterParameterGroupName;
    private Boolean resetAllParameters;
    private ListWithAutoConstructFlag<Parameter> parameters;

    public String getDBClusterParameterGroupName() {
        return this.dBClusterParameterGroupName;
    }

    public void setDBClusterParameterGroupName(String dBClusterParameterGroupName) {
        this.dBClusterParameterGroupName = dBClusterParameterGroupName;
    }

    public ResetDBClusterParameterGroupRequest withDBClusterParameterGroupName(String dBClusterParameterGroupName) {
        this.dBClusterParameterGroupName = dBClusterParameterGroupName;
        return this;
    }

    public Boolean isResetAllParameters() {
        return this.resetAllParameters;
    }

    public void setResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
    }

    public ResetDBClusterParameterGroupRequest withResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
        return this;
    }

    public Boolean getResetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public ResetDBClusterParameterGroupRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public ResetDBClusterParameterGroupRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBClusterParameterGroupName() != null) {
            sb.append("DBClusterParameterGroupName: " + this.getDBClusterParameterGroupName() + ",");
        }
        if (this.isResetAllParameters() != null) {
            sb.append("ResetAllParameters: " + this.isResetAllParameters() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBClusterParameterGroupName() == null ? 0 : this.getDBClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isResetAllParameters() == null ? 0 : this.isResetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDBClusterParameterGroupRequest)) {
            return false;
        }
        ResetDBClusterParameterGroupRequest other = (ResetDBClusterParameterGroupRequest)obj;
        if (other.getDBClusterParameterGroupName() == null ^ this.getDBClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getDBClusterParameterGroupName() != null && !other.getDBClusterParameterGroupName().equals(this.getDBClusterParameterGroupName())) {
            return false;
        }
        if (other.isResetAllParameters() == null ^ this.isResetAllParameters() == null) {
            return false;
        }
        if (other.isResetAllParameters() != null && !other.isResetAllParameters().equals(this.isResetAllParameters())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public ResetDBClusterParameterGroupRequest clone() {
        return (ResetDBClusterParameterGroupRequest)super.clone();
    }
}

