/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.RetryUtils;
import com.metamx.common.guava.Sequence;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.Monitor;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.indexing.appenderator.ActionBasedSegmentAllocator;
import io.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.TaskResource;
import io.druid.indexing.kafka.KafkaDataSourceMetadata;
import io.druid.indexing.kafka.KafkaIOConfig;
import io.druid.indexing.kafka.KafkaPartitions;
import io.druid.indexing.kafka.KafkaTuningConfig;
import io.druid.indexing.overlord.DataSourceMetadata;
import io.druid.indexing.overlord.SegmentPublishResult;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeIOConfig;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.RealtimeMetricsMonitor;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorConfig;
import io.druid.segment.realtime.appenderator.Appenderators;
import io.druid.segment.realtime.appenderator.FiniteAppenderatorDriver;
import io.druid.segment.realtime.appenderator.SegmentAllocator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import io.druid.segment.realtime.firehose.ChatHandler;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class KafkaIndexTask
extends AbstractTask
implements ChatHandler {
    public static final long PAUSE_FOREVER = -1L;
    private static final Logger log = new Logger(KafkaIndexTask.class);
    private static final String TYPE = "index_kafka";
    private static final Random RANDOM = new Random();
    private static final long POLL_TIMEOUT = 100L;
    private static final String METADATA_NEXT_PARTITIONS = "nextPartitions";
    private final DataSchema dataSchema;
    private final InputRowParser<ByteBuffer> parser;
    private final KafkaTuningConfig tuningConfig;
    private final KafkaIOConfig ioConfig;
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    private final Map<Integer, Long> endOffsets = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Long> nextOffsets = new ConcurrentHashMap<Integer, Long>();
    private ObjectMapper mapper;
    private volatile Appenderator appenderator = null;
    private volatile FireDepartmentMetrics fireDepartmentMetrics = null;
    private volatile DateTime startTime;
    private volatile Status status = Status.NOT_STARTED;
    private volatile Thread runThread = null;
    private volatile boolean stopRequested = false;
    private volatile boolean publishOnStop = false;
    private final Lock pauseLock = new ReentrantLock();
    private final Condition hasPaused = this.pauseLock.newCondition();
    private final Condition shouldResume = this.pauseLock.newCondition();
    private volatile boolean pauseRequested = false;
    private volatile long pauseMillis = 0L;

    @JsonCreator
    public KafkaIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ChatHandlerProvider chatHandlerProvider) {
        super(id == null ? KafkaIndexTask.makeTaskId(dataSchema.getDataSource(), RANDOM.nextInt()) : id, String.format("%s_%s", TYPE, dataSchema.getDataSource()), taskResource, dataSchema.getDataSource(), context);
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.parser = (InputRowParser)Preconditions.checkNotNull((Object)dataSchema.getParser(), (Object)"parser");
        this.tuningConfig = (KafkaTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
        this.ioConfig = (KafkaIOConfig)Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        this.endOffsets.putAll(ioConfig.getEndPartitions().getPartitionOffsetMap());
    }

    private static String makeTaskId(String dataSource, int randomBits) {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)(97 + (randomBits >>> i * 4 & 0xF)));
        }
        return Joiner.on((String)"_").join((Object)TYPE, (Object)dataSource, new Object[]{suffix});
    }

    public String getType() {
        return TYPE;
    }

    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return true;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public KafkaTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty(value="ioConfig")
    public KafkaIOConfig getIOConfig() {
        return this.ioConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus run(final TaskToolbox toolbox) throws Exception {
        log.info("Starting up!", new Object[0]);
        this.startTime = DateTime.now();
        this.mapper = toolbox.getObjectMapper();
        this.status = Status.STARTING;
        if (this.chatHandlerProvider.isPresent()) {
            log.info("Found chat handler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
            ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.getId(), (ChatHandler)this);
        } else {
            log.warn("No chat handler detected", new Object[0]);
        }
        this.runThread = Thread.currentThread();
        FireDepartment fireDepartmentForMetrics = new FireDepartment(this.dataSchema, new RealtimeIOConfig(null, null, null), null);
        this.fireDepartmentMetrics = fireDepartmentForMetrics.getMetrics();
        toolbox.getMonitorScheduler().addMonitor((Monitor)new RealtimeMetricsMonitor((List)ImmutableList.of((Object)fireDepartmentForMetrics), (Map)ImmutableMap.of((Object)"taskId", (Object)new String[]{this.getId()})));
        try (Appenderator appenderator0 = this.newAppenderator(this.fireDepartmentMetrics, toolbox);
             FiniteAppenderatorDriver driver = this.newDriver(appenderator0, toolbox);
             final KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            this.appenderator = appenderator0;
            String topic = this.ioConfig.getStartPartitions().getTopic();
            Object restoredMetadata = driver.startJob();
            if (restoredMetadata == null) {
                this.nextOffsets.putAll(this.ioConfig.getStartPartitions().getPartitionOffsetMap());
            } else {
                Map restoredMetadataMap = (Map)restoredMetadata;
                KafkaPartitions restoredNextPartitions = (KafkaPartitions)toolbox.getObjectMapper().convertValue(restoredMetadataMap.get(METADATA_NEXT_PARTITIONS), KafkaPartitions.class);
                this.nextOffsets.putAll(restoredNextPartitions.getPartitionOffsetMap());
                if (!restoredNextPartitions.getTopic().equals(this.ioConfig.getStartPartitions().getTopic())) {
                    throw new ISE("WTF?! Restored topic[%s] but expected topic[%s]", new Object[]{restoredNextPartitions.getTopic(), this.ioConfig.getStartPartitions().getTopic()});
                }
                if (!this.nextOffsets.keySet().equals(this.ioConfig.getStartPartitions().getPartitionOffsetMap().keySet())) {
                    throw new ISE("WTF?! Restored partitions[%s] but expected partitions[%s]", new Object[]{this.nextOffsets.keySet(), this.ioConfig.getStartPartitions().getPartitionOffsetMap().keySet()});
                }
            }
            HashMap sequenceNames = Maps.newHashMap();
            for (Integer partitionNum : this.nextOffsets.keySet()) {
                sequenceNames.put(partitionNum, String.format("%s_%s", this.ioConfig.getBaseSequenceName(), partitionNum));
            }
            Supplier<Committer> committerSupplier = new Supplier<Committer>(){

                public Committer get() {
                    ImmutableMap snapshot = ImmutableMap.copyOf((Map)KafkaIndexTask.this.nextOffsets);
                    return new Committer((Map)snapshot){
                        final /* synthetic */ Map val$snapshot;
                        {
                            this.val$snapshot = map;
                        }

                        public Object getMetadata() {
                            return ImmutableMap.of((Object)KafkaIndexTask.METADATA_NEXT_PARTITIONS, (Object)new KafkaPartitions(KafkaIndexTask.this.ioConfig.getStartPartitions().getTopic(), this.val$snapshot));
                        }

                        public void run() {
                        }
                    };
                }
            };
            Set<Integer> assignment = this.assignPartitionsAndSeekToNext(consumer, topic);
            boolean stillReading = !assignment.isEmpty();
            try {
                while (stillReading) {
                    if (this.possiblyPause(assignment) && (assignment = this.assignPartitionsAndSeekToNext(consumer, topic)).isEmpty()) {
                        log.info("All partitions have been fully read", new Object[0]);
                        this.publishOnStop = true;
                        this.stopRequested = true;
                    }
                    if (this.stopRequested) {
                        break;
                    }
                    ConsumerRecords records = (ConsumerRecords)RetryUtils.retry((Callable)new Callable<ConsumerRecords<byte[], byte[]>>(){

                        @Override
                        public ConsumerRecords<byte[], byte[]> call() throws Exception {
                            try {
                                ConsumerRecords consumerRecords = consumer.poll(100L);
                                return consumerRecords;
                            }
                            finally {
                                KafkaIndexTask.this.status = Status.READING;
                            }
                        }
                    }, (Predicate)new Predicate<Throwable>(){

                        public boolean apply(Throwable input) {
                            return input instanceof OffsetOutOfRangeException;
                        }
                    }, (int)Integer.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        if (log.isTraceEnabled()) {
                            log.trace("Got topic[%s] partition[%d] offset[%,d].", new Object[]{record.topic(), record.partition(), record.offset()});
                        }
                        if (record.offset() < this.endOffsets.get(record.partition())) {
                            if (record.offset() != this.nextOffsets.get(record.partition()).longValue()) {
                                throw new ISE("WTF?! Got offset[%,d] after offset[%,d] in partition[%d].", new Object[]{record.offset(), this.nextOffsets.get(record.partition()), record.partition()});
                            }
                            try {
                                InputRow row = (InputRow)Preconditions.checkNotNull((Object)this.parser.parse((Object)ByteBuffer.wrap((byte[])record.value())), (Object)"row");
                                if (!this.ioConfig.getMinimumMessageTime().isPresent() || !((DateTime)this.ioConfig.getMinimumMessageTime().get()).isAfter((ReadableInstant)row.getTimestamp())) {
                                    SegmentIdentifier identifier = driver.add(row, (String)sequenceNames.get(record.partition()), (Supplier)committerSupplier);
                                    if (identifier == null) {
                                        throw new ISE("Could not allocate segment for row with timestamp[%s]", new Object[]{row.getTimestamp()});
                                    }
                                    this.fireDepartmentMetrics.incrementProcessed();
                                } else {
                                    this.fireDepartmentMetrics.incrementThrownAway();
                                }
                            }
                            catch (ParseException e) {
                                if (this.tuningConfig.isReportParseExceptions()) {
                                    throw e;
                                }
                                log.debug((Throwable)e, "Dropping unparseable row from partition[%d] offset[%,d].", new Object[]{record.partition(), record.offset()});
                                this.fireDepartmentMetrics.incrementUnparseable();
                            }
                            this.nextOffsets.put(record.partition(), record.offset() + 1L);
                        }
                        if (!this.nextOffsets.get(record.partition()).equals(this.endOffsets.get(record.partition())) || !assignment.remove(record.partition())) continue;
                        log.info("Finished reading topic[%s], partition[%,d].", new Object[]{record.topic(), record.partition()});
                        KafkaIndexTask.assignPartitions(consumer, topic, assignment);
                        stillReading = this.ioConfig.isPauseAfterRead() || !assignment.isEmpty();
                    }
                }
            }
            finally {
                driver.persist((Committer)committerSupplier.get());
            }
            if (this.stopRequested && !this.publishOnStop) {
                throw new InterruptedException("Stopping without publishing");
            }
            this.status = Status.PUBLISHING;
            TransactionalSegmentPublisher publisher = new TransactionalSegmentPublisher(){

                public boolean publishSegments(Set<DataSegment> segments, Object commitMetadata) throws IOException {
                    KafkaPartitions finalPartitions = (KafkaPartitions)toolbox.getObjectMapper().convertValue(((Map)commitMetadata).get(KafkaIndexTask.METADATA_NEXT_PARTITIONS), KafkaPartitions.class);
                    if (!KafkaIndexTask.this.endOffsets.equals(finalPartitions.getPartitionOffsetMap())) {
                        throw new ISE("WTF?! Driver attempted to publish invalid metadata[%s].", new Object[]{commitMetadata});
                    }
                    SegmentTransactionalInsertAction action = KafkaIndexTask.this.ioConfig.isUseTransaction() ? new SegmentTransactionalInsertAction(segments, (DataSourceMetadata)new KafkaDataSourceMetadata(KafkaIndexTask.this.ioConfig.getStartPartitions()), (DataSourceMetadata)new KafkaDataSourceMetadata(finalPartitions)) : new SegmentTransactionalInsertAction(segments, null, null);
                    log.info("Publishing with isTransaction[%s].", new Object[]{KafkaIndexTask.this.ioConfig.isUseTransaction()});
                    return ((SegmentPublishResult)toolbox.getTaskActionClient().submit((TaskAction)action)).isSuccess();
                }
            };
            SegmentsAndMetadata published = driver.finish(publisher, (Committer)committerSupplier.get());
            if (published == null) {
                throw new ISE("Transaction failure publishing segments, aborting", new Object[0]);
            }
            log.info("Published segments[%s] with metadata[%s].", new Object[]{Joiner.on((String)", ").join(Iterables.transform((Iterable)published.getSegments(), (Function)new Function<DataSegment, String>(){

                public String apply(DataSegment input) {
                    return input.getIdentifier();
                }
            })), published.getCommitMetadata()});
        }
        catch (InterruptedException e) {
            if (!this.stopRequested) {
                Thread.currentThread().interrupt();
                throw e;
            }
            log.info("The task was asked to stop before completing", new Object[0]);
        }
        return this.success();
    }

    public boolean canRestore() {
        return true;
    }

    @POST
    @Path(value="/stop")
    public void stopGracefully() {
        log.info("Stopping gracefully.", new Object[0]);
        this.stopRequested = true;
        if (this.runThread.isAlive()) {
            log.info("Interrupting run thread (status: [%s])", new Object[]{this.status});
            this.runThread.interrupt();
        }
    }

    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.appenderator == null) {
            return new NoopQueryRunner();
        }
        return new QueryRunner<T>(){

            public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
                return query.run((QuerySegmentWalker)KafkaIndexTask.this.appenderator, responseContext);
            }
        };
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Status getStatus() {
        return this.status;
    }

    @GET
    @Path(value="/offsets/current")
    @Produces(value={"application/json"})
    public Map<Integer, Long> getCurrentOffsets() {
        return this.nextOffsets;
    }

    @GET
    @Path(value="/offsets/end")
    @Produces(value={"application/json"})
    public Map<Integer, Long> getEndOffsets() {
        return this.endOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/offsets/end")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setEndOffsets(Map<Integer, Long> offsets, @QueryParam(value="resume") @DefaultValue(value="false") boolean resume) throws InterruptedException {
        if (offsets == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Request body must contain a map of { partition:endOffset }").build();
        }
        if (!this.endOffsets.keySet().containsAll(offsets.keySet())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Request contains partitions not being handled by this task, my partitions: %s", this.endOffsets.keySet())).build();
        }
        this.pauseLock.lockInterruptibly();
        try {
            if (!this.isPaused()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Task must be paused before changing the end offsets").build();
                return response;
            }
            for (Map.Entry<Integer, Long> entry : offsets.entrySet()) {
                if (entry.getValue().compareTo(this.nextOffsets.get(entry.getKey())) >= 0) continue;
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("End offset must be >= current offset for partition [%s] (current: %s)", entry.getKey(), this.nextOffsets.get(entry.getKey()))).build();
                return response;
            }
            this.endOffsets.putAll(offsets);
            log.info("endOffsets changed to %s", new Object[]{this.endOffsets});
        }
        finally {
            this.pauseLock.unlock();
        }
        if (resume) {
            this.resume();
        }
        return Response.ok(this.endOffsets).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/pause")
    @Produces(value={"application/json"})
    public Response pause(@QueryParam(value="timeout") @DefaultValue(value="0") long timeout) throws InterruptedException {
        if (this.status != Status.PAUSED && this.status != Status.READING) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Can't pause, task is not in a pausable state (state: [%s])", new Object[]{this.status})).build();
        }
        this.pauseLock.lockInterruptibly();
        try {
            this.pauseMillis = timeout <= 0L ? -1L : timeout;
            this.pauseRequested = true;
            if (this.isPaused()) {
                this.shouldResume.signalAll();
            }
            long nanos = TimeUnit.SECONDS.toNanos(2L);
            while (!this.isPaused()) {
                if (nanos <= 0L) {
                    Response response = Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"Request accepted but task has not yet paused").build();
                    return response;
                }
                nanos = this.hasPaused.awaitNanos(nanos);
            }
        }
        finally {
            this.pauseLock.unlock();
        }
        try {
            return Response.ok().entity((Object)this.mapper.writeValueAsString(this.getCurrentOffsets())).build();
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @POST
    @Path(value="/resume")
    public void resume() throws InterruptedException {
        this.pauseLock.lockInterruptibly();
        try {
            this.pauseRequested = false;
            this.shouldResume.signalAll();
            long nanos = TimeUnit.SECONDS.toNanos(5L);
            while (this.isPaused()) {
                if (nanos <= 0L) {
                    throw new RuntimeException("Resume command was not accepted within 5 seconds");
                }
                nanos = this.shouldResume.awaitNanos(nanos);
            }
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @GET
    @Path(value="/time/start")
    @Produces(value={"application/json"})
    public DateTime getStartTime() {
        return this.startTime;
    }

    @VisibleForTesting
    FireDepartmentMetrics getFireDepartmentMetrics() {
        return this.fireDepartmentMetrics;
    }

    private boolean isPaused() {
        return this.status == Status.PAUSED;
    }

    private Appenderator newAppenderator(FireDepartmentMetrics metrics, TaskToolbox toolbox) {
        return Appenderators.createRealtime((DataSchema)this.dataSchema, (AppenderatorConfig)this.tuningConfig.withBasePersistDirectory(new File(toolbox.getTaskWorkDir(), "persist")), (FireDepartmentMetrics)metrics, (DataSegmentPusher)toolbox.getSegmentPusher(), (ObjectMapper)toolbox.getObjectMapper(), (IndexIO)toolbox.getIndexIO(), (IndexMerger)(this.tuningConfig.getBuildV9Directly() ? toolbox.getIndexMergerV9() : toolbox.getIndexMerger()), (QueryRunnerFactoryConglomerate)toolbox.getQueryRunnerFactoryConglomerate(), (DataSegmentAnnouncer)toolbox.getSegmentAnnouncer(), (ServiceEmitter)toolbox.getEmitter(), (ExecutorService)toolbox.getQueryExecutorService(), (Cache)toolbox.getCache(), (CacheConfig)toolbox.getCacheConfig());
    }

    private FiniteAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox) {
        return new FiniteAppenderatorDriver(appenderator, (SegmentAllocator)new ActionBasedSegmentAllocator(toolbox.getTaskActionClient(), this.dataSchema), toolbox.getSegmentHandoffNotifierFactory(), (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()), toolbox.getObjectMapper(), this.tuningConfig.getMaxRowsPerSegment(), this.tuningConfig.getHandoffConditionTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaConsumer<byte[], byte[]> newConsumer() {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Properties props = new Properties();
            for (Map.Entry<String, String> entry : this.ioConfig.getConsumerProperties().entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue());
            }
            props.setProperty("enable.auto.commit", "false");
            props.setProperty("auto.offset.reset", "none");
            props.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
            props.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
            KafkaConsumer kafkaConsumer = new KafkaConsumer(props);
            return kafkaConsumer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    private static void assignPartitions(KafkaConsumer consumer, final String topic, Set<Integer> partitions) {
        consumer.assign((List)Lists.newArrayList((Iterable)Iterables.transform(partitions, (Function)new Function<Integer, TopicPartition>(){

            public TopicPartition apply(Integer n) {
                return new TopicPartition(topic, n.intValue());
            }
        })));
    }

    private Set<Integer> assignPartitionsAndSeekToNext(KafkaConsumer consumer, String topic) {
        HashSet assignment = Sets.newHashSet();
        for (Map.Entry<Integer, Long> entry : this.nextOffsets.entrySet()) {
            long endOffset = this.endOffsets.get(entry.getKey());
            if (entry.getValue() < endOffset) {
                assignment.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == endOffset) {
                log.info("Finished reading partition[%d].", new Object[]{entry.getKey()});
                continue;
            }
            throw new ISE("WTF?! Cannot start from offset[%,d] > endOffset[%,d]", new Object[]{entry.getValue(), endOffset});
        }
        KafkaIndexTask.assignPartitions(consumer, topic, assignment);
        Iterator<Map.Entry<Integer, Long>> iterator = assignment.iterator();
        while (iterator.hasNext()) {
            int partition = (Integer)((Object)iterator.next());
            long offset = this.nextOffsets.get(partition);
            log.info("Seeking partition[%d] to offset[%,d].", new Object[]{partition, offset});
            consumer.seek(new TopicPartition(topic, partition), offset);
        }
        return assignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean possiblyPause(Set<Integer> assignment) throws InterruptedException {
        this.pauseLock.lockInterruptibly();
        try {
            if (this.ioConfig.isPauseAfterRead() && assignment.isEmpty()) {
                this.pauseMillis = -1L;
                this.pauseRequested = true;
            }
            if (this.pauseRequested) {
                this.status = Status.PAUSED;
                long nanos = 0L;
                this.hasPaused.signalAll();
                while (this.pauseRequested) {
                    if (this.pauseMillis == -1L) {
                        log.info("Pausing ingestion until resumed", new Object[0]);
                        this.shouldResume.await();
                        continue;
                    }
                    if (this.pauseMillis > 0L) {
                        log.info("Pausing ingestion for [%,d] ms", new Object[]{this.pauseMillis});
                        nanos = TimeUnit.MILLISECONDS.toNanos(this.pauseMillis);
                        this.pauseMillis = 0L;
                    }
                    if (nanos <= 0L) {
                        this.pauseRequested = false;
                    }
                    nanos = this.shouldResume.awaitNanos(nanos);
                }
                this.status = Status.READING;
                this.shouldResume.signalAll();
                log.info("Ingestion loop resumed", new Object[0]);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.pauseLock.unlock();
        }
        return false;
    }

    public static enum Status {
        NOT_STARTED,
        STARTING,
        READING,
        PAUSED,
        PUBLISHING;

    }
}

