/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.emitter.EmittingLogger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.FullResponseHandler;
import com.metamx.http.client.response.FullResponseHolder;
import com.metamx.http.client.response.HttpResponseHandler;
import io.druid.indexing.common.RetryPolicy;
import io.druid.indexing.common.RetryPolicyConfig;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.TaskInfoProvider;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.kafka.KafkaIndexTask;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaIndexTaskClient {
    private static final EmittingLogger log = new EmittingLogger(KafkaIndexTaskClient.class);
    private static final String BASE_PATH = "/druid/worker/v1/chat";
    private static final int TASK_MISMATCH_RETRY_DELAY_SECONDS = 5;
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;
    private final TaskInfoProvider taskInfoProvider;
    private final RetryPolicyFactory retryPolicyFactory;

    public KafkaIndexTaskClient(HttpClient httpClient, ObjectMapper jsonMapper, TaskInfoProvider taskInfoProvider) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.taskInfoProvider = taskInfoProvider;
        this.retryPolicyFactory = this.createRetryPolicyFactory();
    }

    public void stop(String id, boolean publish) {
        this.submitRequest(id, HttpMethod.POST, "stop", publish ? "publish=true" : null, true);
    }

    public void resume(String id) {
        this.submitRequest(id, HttpMethod.POST, "resume", null, true);
    }

    public Map<Integer, Long> pause(String id) {
        return this.pause(id, 0L);
    }

    public Map<Integer, Long> pause(String id, long timeout) {
        try {
            FullResponseHolder response = this.submitRequest(id, HttpMethod.POST, "pause", timeout > 0L ? String.format("timeout=%d", timeout) : null, true);
            if (response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<Integer, Long>>(){});
            }
            RetryPolicy retryPolicy = this.retryPolicyFactory.makeRetryPolicy();
            while (true) {
                if (this.getStatus(id) == KafkaIndexTask.Status.PAUSED) {
                    return this.getCurrentOffsets(id, true);
                }
                Duration delay = retryPolicy.getAndIncrementRetryDelay();
                if (delay == null) {
                    throw new ISE("Task [%s] failed to pause, aborting", new Object[]{id});
                }
                long sleepTime = delay.getMillis();
                log.info("Still waiting for task [%s] to pause; will try again in [%s]", new Object[]{id, new Duration(sleepTime).toString()});
                Thread.sleep(sleepTime);
            }
        }
        catch (IOException | InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public KafkaIndexTask.Status getStatus(String id) {
        try {
            FullResponseHolder response = this.submitRequest(id, HttpMethod.GET, "status", null, true);
            return (KafkaIndexTask.Status)((Object)this.jsonMapper.readValue(response.getContent(), KafkaIndexTask.Status.class));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public DateTime getStartTime(String id, boolean retry) {
        try {
            FullResponseHolder response = this.submitRequest(id, HttpMethod.GET, "time/start", null, retry);
            return response.getContent() == null || response.getContent().isEmpty() ? null : (DateTime)this.jsonMapper.readValue(response.getContent(), DateTime.class);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Map<Integer, Long> getCurrentOffsets(String id, boolean retry) {
        try {
            FullResponseHolder response = this.submitRequest(id, HttpMethod.GET, "offsets/current", null, retry);
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<Integer, Long>>(){});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Map<Integer, Long> getEndOffsets(String id) {
        try {
            FullResponseHolder response = this.submitRequest(id, HttpMethod.GET, "offsets/end", null, true);
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<Integer, Long>>(){});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void setEndOffsets(String id, Map<Integer, Long> endOffsets) {
        this.setEndOffsets(id, endOffsets, false);
    }

    public void setEndOffsets(String id, Map<Integer, Long> endOffsets, boolean resume) {
        try {
            this.submitRequest(id, HttpMethod.POST, "offsets/end", resume ? "resume=true" : null, this.jsonMapper.writeValueAsBytes(endOffsets), true);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    RetryPolicyFactory createRetryPolicyFactory() {
        return new RetryPolicyFactory(new RetryPolicyConfig().setMinWait(Period.seconds((int)2)).setMaxWait(Period.seconds((int)8)).setMaxRetryCount(8L));
    }

    @VisibleForTesting
    void checkConnection(String host, int port) throws IOException {
        new Socket(host, port).close();
    }

    private FullResponseHolder submitRequest(String id, HttpMethod method, String pathSuffix, String query, boolean retry) {
        return this.submitRequest(id, method, pathSuffix, query, new byte[0], retry);
    }

    private FullResponseHolder submitRequest(String id, HttpMethod method, String pathSuffix, String query, byte[] content, boolean retry) {
        RetryPolicy retryPolicy = this.retryPolicyFactory.makeRetryPolicy();
        while (true) {
            FullResponseHolder response = null;
            Request request = null;
            Optional status = this.taskInfoProvider.getTaskStatus(id);
            if (!status.isPresent() || !((TaskStatus)status.get()).isRunnable()) {
                throw new TaskNotRunnableException(String.format("Aborting request because task [%s] is not runnable", id));
            }
            try {
                TaskLocation location = this.taskInfoProvider.getTaskLocation(id);
                if (location.equals((Object)TaskLocation.unknown())) {
                    log.info("No TaskLocation available for task [%s], this task may not have been assigned to a worker yet", new Object[]{id});
                    throw new NoTaskLocationException(String.format("No TaskLocation available for task [%s]", id));
                }
                this.checkConnection(location.getHost(), location.getPort());
                try {
                    URI serviceUri = new URI("http", null, location.getHost(), location.getPort(), String.format("%s/%s/%s", BASE_PATH, id, pathSuffix), query, null);
                    request = new Request(method, serviceUri.toURL());
                    request.addHeader("X-Druid-Task-Id", id);
                    if (content.length > 0) {
                        request.setContent("application/json", content);
                    }
                    response = (FullResponseHolder)this.httpClient.go(request, (HttpResponseHandler)new FullResponseHandler(Charsets.UTF_8)).get();
                }
                catch (Exception e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ChannelException.class);
                    throw Throwables.propagate((Throwable)e);
                }
                int responseCode = response.getStatus().getCode();
                if (responseCode / 100 == 2) {
                    return response;
                }
                if (responseCode == 400) {
                    throw new IAE("Received 400 Bad Request with body: %s", new Object[]{response.getContent()});
                }
                throw new IOException(String.format("Received status [%d]", responseCode));
            }
            catch (IOException | ChannelException e) {
                Duration delay;
                if (response != null && response.getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
                    String headerId = response.getResponse().headers().get("X-Druid-Task-Id");
                    if (headerId != null && !headerId.equals(id)) {
                        log.warn("Expected worker to have taskId [%s] but has taskId [%s], will retry in [%d]s", new Object[]{id, headerId, 5});
                        delay = Duration.standardSeconds((long)5L);
                    } else {
                        delay = retryPolicy.getAndIncrementRetryDelay();
                    }
                } else {
                    delay = retryPolicy.getAndIncrementRetryDelay();
                }
                if (!retry || delay == null) {
                    Throwables.propagate((Throwable)e);
                    continue;
                }
                try {
                    long sleepTime = delay.getMillis();
                    log.debug("Bad response HTTP [%d] from %s; will try again in [%s] (body: [%s])", new Object[]{response != null ? response.getStatus().getCode() : 0, request != null ? request.getUrl() : "-", new Duration(sleepTime).toString(), response != null ? response.getContent() : "[empty]"});
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e2) {
                    Throwables.propagate((Throwable)e2);
                    continue;
                }
            }
            break;
        }
    }

    public class TaskNotRunnableException
    extends RuntimeException {
        public TaskNotRunnableException(String message) {
            super(message);
        }
    }

    public class NoTaskLocationException
    extends RuntimeException {
        public NoTaskLocationException(String message) {
            super(message);
        }
    }
}

