/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class KafkaPartitions {
    private final String topic;
    private final Map<Integer, Long> partitionOffsetMap;

    @JsonCreator
    public KafkaPartitions(@JsonProperty(value="topic") String topic, @JsonProperty(value="partitionOffsetMap") Map<Integer, Long> partitionOffsetMap) {
        this.topic = topic;
        this.partitionOffsetMap = ImmutableMap.copyOf(partitionOffsetMap);
        for (Map.Entry<Integer, Long> entry : partitionOffsetMap.entrySet()) {
            Preconditions.checkArgument((entry.getValue() >= 0L ? 1 : 0) != 0, (Object)String.format("partition[%d] offset[%d] invalid", entry.getKey(), entry.getValue()));
        }
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public Map<Integer, Long> getPartitionOffsetMap() {
        return this.partitionOffsetMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaPartitions that = (KafkaPartitions)o;
        return Objects.equals(this.topic, that.topic) && Objects.equals(this.partitionOffsetMap, that.partitionOffsetMap);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partitionOffsetMap);
    }

    public String toString() {
        return "KafkaPartitions{topic='" + this.topic + '\'' + ", partitionOffsetMap=" + this.partitionOffsetMap + '}';
    }
}

