/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.realtime.appenderator.AppenderatorConfig;
import java.io.File;
import org.joda.time.Period;

public class KafkaTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int DEFAULT_MAX_ROWS_PER_SEGMENT = 5000000;
    private final int maxRowsInMemory;
    private final int maxRowsPerSegment;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    private final int maxPendingPersists;
    private final IndexSpec indexSpec;
    private final boolean buildV9Directly;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;

    @JsonCreator
    public KafkaTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout) {
        RealtimeTuningConfig defaults = RealtimeTuningConfig.makeDefaultTuningConfig((File)basePersistDirectory);
        this.maxRowsInMemory = maxRowsInMemory == null ? defaults.getMaxRowsInMemory() : maxRowsInMemory.intValue();
        this.maxRowsPerSegment = maxRowsPerSegment == null ? 5000000 : maxRowsPerSegment;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaults.getIntermediatePersistPeriod() : intermediatePersistPeriod;
        this.basePersistDirectory = defaults.getBasePersistDirectory();
        this.maxPendingPersists = maxPendingPersists == null ? defaults.getMaxPendingPersists() : maxPendingPersists.intValue();
        this.indexSpec = indexSpec == null ? defaults.getIndexSpec() : indexSpec;
        this.buildV9Directly = buildV9Directly == null ? defaults.getBuildV9Directly() : buildV9Directly;
        this.reportParseExceptions = reportParseExceptions == null ? defaults.isReportParseExceptions() : reportParseExceptions.booleanValue();
        this.handoffConditionTimeout = handoffConditionTimeout == null ? defaults.getHandoffConditionTimeout() : handoffConditionTimeout.longValue();
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public int getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public boolean getBuildV9Directly() {
        return this.buildV9Directly;
    }

    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    public KafkaTuningConfig withBasePersistDirectory(File dir) {
        return new KafkaTuningConfig(this.maxRowsInMemory, this.maxRowsPerSegment, this.intermediatePersistPeriod, dir, this.maxPendingPersists, this.indexSpec, this.buildV9Directly, this.reportParseExceptions, this.handoffConditionTimeout);
    }
}

