/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.joda.time.Duration;
import org.joda.time.Period;

public class KafkaSupervisorIOConfig {
    public static final String BOOTSTRAP_SERVERS_KEY = "bootstrap.servers";
    private final String topic;
    private final Integer replicas;
    private final Integer taskCount;
    private final Duration taskDuration;
    private final Map<String, String> consumerProperties;
    private final Duration startDelay;
    private final Duration period;
    private final Boolean useEarliestOffset;
    private final Duration completionTimeout;
    private final Optional<Duration> lateMessageRejectionPeriod;

    @JsonCreator
    public KafkaSupervisorIOConfig(@JsonProperty(value="topic") String topic, @JsonProperty(value="replicas") Integer replicas, @JsonProperty(value="taskCount") Integer taskCount, @JsonProperty(value="taskDuration") Period taskDuration, @JsonProperty(value="consumerProperties") Map<String, String> consumerProperties, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="period") Period period, @JsonProperty(value="useEarliestOffset") Boolean useEarliestOffset, @JsonProperty(value="completionTimeout") Period completionTimeout, @JsonProperty(value="lateMessageRejectionPeriod") Period lateMessageRejectionPeriod) {
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"topic");
        this.consumerProperties = (Map)Preconditions.checkNotNull(consumerProperties, (Object)"consumerProperties");
        Preconditions.checkNotNull((Object)consumerProperties.get(BOOTSTRAP_SERVERS_KEY), (Object)String.format("consumerProperties must contain entry for [%s]", BOOTSTRAP_SERVERS_KEY));
        this.replicas = replicas != null ? replicas : 1;
        this.taskCount = taskCount != null ? taskCount : 1;
        this.taskDuration = KafkaSupervisorIOConfig.defaultDuration(taskDuration, "PT1H");
        this.startDelay = KafkaSupervisorIOConfig.defaultDuration(startDelay, "PT5S");
        this.period = KafkaSupervisorIOConfig.defaultDuration(period, "PT30S");
        this.useEarliestOffset = useEarliestOffset != null ? useEarliestOffset : false;
        this.completionTimeout = KafkaSupervisorIOConfig.defaultDuration(completionTimeout, "PT30M");
        this.lateMessageRejectionPeriod = lateMessageRejectionPeriod == null ? Optional.absent() : Optional.of((Object)lateMessageRejectionPeriod.toStandardDuration());
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public Integer getReplicas() {
        return this.replicas;
    }

    @JsonProperty
    public Integer getTaskCount() {
        return this.taskCount;
    }

    @JsonProperty
    public Duration getTaskDuration() {
        return this.taskDuration;
    }

    @JsonProperty
    public Map<String, String> getConsumerProperties() {
        return this.consumerProperties;
    }

    @JsonProperty
    public Duration getStartDelay() {
        return this.startDelay;
    }

    @JsonProperty
    public Duration getPeriod() {
        return this.period;
    }

    @JsonProperty
    public Boolean isUseEarliestOffset() {
        return this.useEarliestOffset;
    }

    @JsonProperty
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @JsonProperty
    public Optional<Duration> getLateMessageRejectionPeriod() {
        return this.lateMessageRejectionPeriod;
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }
}

