/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.druid.indexing.overlord.supervisor.SupervisorReport;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class KafkaSupervisorReport
extends SupervisorReport {
    private final KafkaSupervisorReportPayload payload;

    public KafkaSupervisorReport(String dataSource, DateTime generationTime, String topic, Integer partitions, Integer replicas, Long durationSeconds) {
        super(dataSource, generationTime);
        this.payload = new KafkaSupervisorReportPayload(dataSource, topic, partitions, replicas, durationSeconds);
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addActiveTask(String id, Map<Integer, Long> startingOffsets, Map<Integer, Long> currentOffsets, DateTime startTime, Long remainingSeconds) {
        this.payload.activeTasks.add(new TaskReportData(id, startingOffsets, currentOffsets, startTime, remainingSeconds));
    }

    public void addPublishingTask(String id, Map<Integer, Long> startingOffsets, Map<Integer, Long> currentOffsets, DateTime startTime, Long remainingSeconds) {
        this.payload.publishingTasks.add(new TaskReportData(id, startingOffsets, currentOffsets, startTime, remainingSeconds));
    }

    public String toString() {
        return "{id='" + this.getId() + '\'' + ", generationTime=" + this.getGenerationTime() + ", payload=" + this.payload + '}';
    }

    public class KafkaSupervisorReportPayload {
        private final String dataSource;
        private final String topic;
        private final Integer partitions;
        private final Integer replicas;
        private final Long durationSeconds;
        private final List<TaskReportData> activeTasks;
        private final List<TaskReportData> publishingTasks;

        public KafkaSupervisorReportPayload(String dataSource, String topic, Integer partitions, Integer replicas, Long durationSeconds) {
            this.dataSource = dataSource;
            this.topic = topic;
            this.partitions = partitions;
            this.replicas = replicas;
            this.durationSeconds = durationSeconds;
            this.activeTasks = Lists.newArrayList();
            this.publishingTasks = Lists.newArrayList();
        }

        @JsonProperty
        public String getDataSource() {
            return this.dataSource;
        }

        @JsonProperty
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty
        public Integer getPartitions() {
            return this.partitions;
        }

        @JsonProperty
        public Integer getReplicas() {
            return this.replicas;
        }

        @JsonProperty
        public Long getDurationSeconds() {
            return this.durationSeconds;
        }

        @JsonProperty
        public List<TaskReportData> getActiveTasks() {
            return this.activeTasks;
        }

        @JsonProperty
        public List<TaskReportData> getPublishingTasks() {
            return this.publishingTasks;
        }

        public String toString() {
            return "{dataSource='" + this.dataSource + '\'' + ", topic='" + this.topic + '\'' + ", partitions=" + this.partitions + ", replicas=" + this.replicas + ", durationSeconds=" + this.durationSeconds + ", active=" + this.activeTasks + ", publishing=" + this.publishingTasks + '}';
        }
    }

    public class TaskReportData {
        private final String id;
        private final Map<Integer, Long> startingOffsets;
        private final Map<Integer, Long> currentOffsets;
        private final DateTime startTime;
        private final Long remainingSeconds;

        public TaskReportData(String id, Map<Integer, Long> startingOffsets, Map<Integer, Long> currentOffsets, DateTime startTime, Long remainingSeconds) {
            this.id = id;
            this.startingOffsets = startingOffsets;
            this.currentOffsets = currentOffsets;
            this.startTime = startTime;
            this.remainingSeconds = remainingSeconds;
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public Map<Integer, Long> getStartingOffsets() {
            return this.startingOffsets;
        }

        @JsonProperty
        public Map<Integer, Long> getCurrentOffsets() {
            return this.currentOffsets;
        }

        @JsonProperty
        public DateTime getStartTime() {
            return this.startTime;
        }

        @JsonProperty
        public Long getRemainingSeconds() {
            return this.remainingSeconds;
        }

        public String toString() {
            return "{id='" + this.id + '\'' + (this.startingOffsets != null ? ", startingOffsets=" + this.startingOffsets : "") + (this.currentOffsets != null ? ", currentOffsets=" + this.currentOffsets : "") + ", startTime=" + this.startTime + ", remainingSeconds=" + this.remainingSeconds + '}';
        }
    }
}

