/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.druid.guice.annotations.Json;
import io.druid.indexing.kafka.KafkaIndexTaskClientFactory;
import io.druid.indexing.kafka.KafkaTuningConfig;
import io.druid.indexing.kafka.supervisor.KafkaSupervisor;
import io.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.supervisor.Supervisor;
import io.druid.indexing.overlord.supervisor.SupervisorSpec;
import io.druid.segment.indexing.DataSchema;

public class KafkaSupervisorSpec
implements SupervisorSpec {
    private final DataSchema dataSchema;
    private final KafkaTuningConfig tuningConfig;
    private final KafkaSupervisorIOConfig ioConfig;
    private final TaskStorage taskStorage;
    private final TaskMaster taskMaster;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final KafkaIndexTaskClientFactory kafkaIndexTaskClientFactory;
    private final ObjectMapper mapper;

    @JsonCreator
    public KafkaSupervisorSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaSupervisorIOConfig ioConfig, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject KafkaIndexTaskClientFactory kafkaIndexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper) {
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.tuningConfig = tuningConfig != null ? tuningConfig : new KafkaTuningConfig(null, null, null, null, null, null, null, null, null);
        this.ioConfig = (KafkaSupervisorIOConfig)Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
        this.taskStorage = taskStorage;
        this.taskMaster = taskMaster;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.kafkaIndexTaskClientFactory = kafkaIndexTaskClientFactory;
        this.mapper = mapper;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public KafkaTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public KafkaSupervisorIOConfig getIoConfig() {
        return this.ioConfig;
    }

    public String getId() {
        return this.dataSchema.getDataSource();
    }

    public Supervisor createSupervisor() {
        return new KafkaSupervisor(this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, this.kafkaIndexTaskClientFactory, this.mapper, this);
    }
}

