/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.ISE;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Rows {
    public static InputRow toCaseInsensitiveInputRow(Row row, List<String> dimensions) {
        if (row instanceof MapBasedRow) {
            MapBasedRow mapBasedRow = (MapBasedRow)row;
            TreeMap caseInsensitiveMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveMap.putAll(mapBasedRow.getEvent());
            return new MapBasedInputRow(mapBasedRow.getTimestamp(), dimensions, (Map<String, Object>)caseInsensitiveMap);
        }
        throw new ISE("Can only convert MapBasedRow objects because we are ghetto like that.", new Object[0]);
    }

    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap dims = Maps.newTreeMap();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of((Object)timeStamp, (Object)dims);
    }
}

