/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.parsers.CSVParser;
import io.druid.java.util.common.parsers.Parser;
import java.util.List;

public class CSVParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;
    private final boolean hasHeaderRow;
    private final int skipHeaderRows;

    @JsonCreator
    public CSVParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="hasHeaderRow") boolean hasHeaderRow, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.hasHeaderRow = hasHeaderRow;
        this.skipHeaderRows = skipHeaderRows;
        if (columns != null) {
            for (String column : columns) {
                Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object[])new Object[]{column});
            }
            this.verify(dimensionsSpec.getDimensionNames());
        } else {
            Preconditions.checkArgument((boolean)hasHeaderRow, (Object)"If columns field is not set, the first row of your data must have your header and hasHeaderRow must be set to true.");
        }
    }

    @Deprecated
    public CSVParseSpec(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, String listDelimiter, List<String> columns) {
        this(timestampSpec, dimensionsSpec, listDelimiter, columns, false, 0);
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public boolean isHasHeaderRow() {
        return this.hasHeaderRow;
    }

    @JsonProperty(value="skipHeaderRows")
    public int getSkipHeaderRows() {
        return this.skipHeaderRows;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new CSVParser(this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new CSVParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new CSVParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    public ParseSpec withColumns(List<String> cols) {
        return new CSVParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.listDelimiter, cols, this.hasHeaderRow, this.skipHeaderRows);
    }
}

