/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.parsers.JavaScriptParser;
import io.druid.java.util.common.parsers.Parser;
import io.druid.js.JavaScriptConfig;
import java.util.List;

public class JavaScriptParseSpec
extends ParseSpec {
    private final String function;
    private final JavaScriptConfig config;

    @JsonCreator
    public JavaScriptParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="function") String function, @JacksonInject JavaScriptConfig config) {
        super(timestampSpec, dimensionsSpec);
        this.function = function;
        this.config = config;
    }

    @JsonProperty(value="function")
    public String getFunction() {
        return this.function;
    }

    @Override
    public void verify(List<String> usedCols) {
    }

    @Override
    public Parser<String, Object> makeParser() {
        if (!this.config.isEnabled()) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        return new JavaScriptParser(this.function);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new JavaScriptParseSpec(spec, this.getDimensionsSpec(), this.function, this.config);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new JavaScriptParseSpec(this.getTimestampSpec(), spec, this.function, this.config);
    }

    public ParseSpec withFunction(String fn) {
        return new JavaScriptParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), fn, this.config);
    }
}

