/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SegmentUtils {
    public static int getVersionFromDir(File inDir) throws IOException {
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray((byte[])Files.toByteArray((File)versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        if (indexFile.exists()) {
            int version;
            try (FileInputStream in = new FileInputStream(indexFile);){
                version = ((InputStream)in).read();
            }
            return version;
        }
        throw new IOException(String.format("Invalid segment dir [%s]. Can't find either of version.bin or index.drd.", inDir));
    }
}

