/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.base.Joiner;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface DataSegmentPusher {
    public static final Joiner JOINER = Joiner.on((String)"/").skipNulls();

    @Deprecated
    public String getPathForHadoop(String var1);

    public String getPathForHadoop();

    public DataSegment push(File var1, DataSegment var2) throws IOException;

    public Map<String, Object> makeLoadSpec(URI var1);

    default public String getStorageDir(DataSegment dataSegment) {
        return DataSegmentPusher.getDefaultStorageDir(dataSegment);
    }

    default public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return String.format("./%s/%s", this.getStorageDir(dataSegment), indexName);
    }

    default public List<String> getAllowedPropertyPrefixesForHadoop() {
        return Collections.emptyList();
    }

    public static String getDefaultStorageDir(DataSegment segment) {
        return JOINER.join((Object)segment.getDataSource(), (Object)String.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), new Object[]{segment.getVersion(), segment.getShardSpec().getPartitionNum()});
    }
}

