/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.impl.FileIteratingFirehose;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.java.util.common.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public abstract class AbstractTextFilesFirehoseFactory<T>
implements FirehoseFactory<StringInputRowParser> {
    private static final Logger LOG = new Logger(AbstractTextFilesFirehoseFactory.class);
    private List<T> objects;

    @Override
    public Firehose connect(StringInputRowParser firehoseParser, File temporaryDirectory) throws IOException {
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(this.initObjects(), (Object)"initObjects")));
        }
        final Iterator<T> iterator = this.objects.iterator();
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public LineIterator next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = iterator.next();
                try {
                    return IOUtils.lineIterator((InputStream)AbstractTextFilesFirehoseFactory.this.wrapObjectStream(object, AbstractTextFilesFirehoseFactory.this.openObjectStream(object)), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Exception reading object[%s]", new Object[]{object});
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }, firehoseParser);
    }

    protected abstract Collection<T> initObjects() throws IOException;

    protected abstract InputStream openObjectStream(T var1) throws IOException;

    protected abstract InputStream wrapObjectStream(T var1, InputStream var2) throws IOException;
}

