/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import io.druid.data.input.Firehose;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.utils.Runnables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.io.LineIterator;

public class FileIteratingFirehose
implements Firehose {
    private final Iterator<LineIterator> lineIterators;
    private final StringInputRowParser parser;
    private LineIterator lineIterator = null;
    private final Closeable closer;

    public FileIteratingFirehose(Iterator<LineIterator> lineIterators, StringInputRowParser parser) {
        this(lineIterators, parser, null);
    }

    public FileIteratingFirehose(Iterator<LineIterator> lineIterators, StringInputRowParser parser, Closeable closer) {
        this.lineIterators = lineIterators;
        this.parser = parser;
        this.closer = closer;
    }

    @Override
    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.lineIterators.hasNext()) {
            this.lineIterator = this.getNextLineIterator();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    @Nullable
    public InputRow nextRow() {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        return this.parser.parse(this.lineIterator.next());
    }

    private LineIterator getNextLineIterator() {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        LineIterator iterator = this.lineIterators.next();
        this.parser.startFileFromBeginning();
        return iterator;
    }

    @Override
    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.lineIterator != null) {
                this.lineIterator.close();
            }
        }
        catch (Throwable t) {
            try {
                if (this.closer != null) {
                    this.closer.close();
                }
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
        if (this.closer != null) {
            this.closer.close();
        }
    }
}

