/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.parsers.Parser;
import io.druid.java.util.common.parsers.RegexParser;
import java.util.List;

public class RegexParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;
    private final String pattern;

    @JsonCreator
    public RegexParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="pattern") String pattern) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.pattern = pattern;
        this.verify(dimensionsSpec.getDimensionNames());
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        if (this.columns != null) {
            for (String columnName : usedCols) {
                Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
            }
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        if (this.columns == null) {
            return new RegexParser(this.pattern, Optional.fromNullable((Object)this.listDelimiter));
        }
        return new RegexParser(this.pattern, Optional.fromNullable((Object)this.listDelimiter), this.columns);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new RegexParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns, this.pattern);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new RegexParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns, this.pattern);
    }
}

