/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import io.druid.data.input.Row;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class MapBasedRow
implements Row {
    private static final Logger log = new Logger(MapBasedRow.class);
    private final DateTime timestamp;
    private final Map<String, Object> event;
    private static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    @JsonCreator
    public MapBasedRow(@JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="event") Map<String, Object> event) {
        this.timestamp = timestamp;
        this.event = event;
    }

    public MapBasedRow(long timestamp, Map<String, Object> event) {
        this(new DateTime(timestamp), event);
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Map<String, Object> getEvent() {
        return this.event;
    }

    @Override
    public List<String> getDimension(String dimension) {
        Object dimValue = this.event.get(dimension);
        if (dimValue == null) {
            return Lists.newArrayList();
        }
        if (dimValue instanceof List) {
            return Lists.transform((List)((List)dimValue), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return String.valueOf(input);
                }
            });
        }
        if (dimValue instanceof Object) {
            return Arrays.asList(String.valueOf(this.event.get(dimension)));
        }
        throw new IAE("Unknown dim type[%s]", new Object[]{dimValue.getClass()});
    }

    @Override
    public Object getRaw(String dimension) {
        return this.event.get(dimension);
    }

    @Override
    public float getFloatMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return 0.0f;
        }
        if (metricValue instanceof Number) {
            return ((Number)metricValue).floatValue();
        }
        if (metricValue instanceof String) {
            try {
                return Float.valueOf(((String)metricValue).replace(",", "")).floatValue();
            }
            catch (Exception e) {
                throw new ParseException((Throwable)e, "Unable to parse metrics[%s], value[%s]", new Object[]{metric, metricValue});
            }
        }
        throw new ParseException("Unknown type[%s]", new Object[]{metricValue.getClass()});
    }

    @Override
    public long getLongMetric(String metric) {
        Object metricValue = this.event.get(metric);
        if (metricValue == null) {
            return 0L;
        }
        if (metricValue instanceof Number) {
            return ((Number)metricValue).longValue();
        }
        if (metricValue instanceof String) {
            try {
                String s = ((String)metricValue).replace(",", "");
                return LONG_PAT.matcher(s).matches() ? Long.valueOf(s).longValue() : Double.valueOf(s).longValue();
            }
            catch (Exception e) {
                throw new ParseException((Throwable)e, "Unable to parse metrics[%s], value[%s]", new Object[]{metric, metricValue});
            }
        }
        throw new ParseException("Unknown type[%s]", new Object[]{metricValue.getClass()});
    }

    public String toString() {
        return "MapBasedRow{timestamp=" + this.timestamp + ", event=" + this.event + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedRow that = (MapBasedRow)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.timestamp.equals((Object)that.timestamp);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }

    @Override
    public int compareTo(Row o) {
        return this.timestamp.compareTo((Object)o.getTimestamp());
    }
}

