/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.metamx.common.parsers.CSVParser;
import com.metamx.common.parsers.Parser;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import java.util.List;

public class CSVParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;

    @JsonCreator
    public CSVParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        Preconditions.checkNotNull(columns, (Object)"columns");
        for (String column : columns) {
            Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object[])new Object[]{column});
        }
        this.columns = columns;
        this.verify(dimensionsSpec.getDimensions());
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument((boolean)this.columns.contains(columnName), (String)"column[%s] not in columns.", (Object[])new Object[]{columnName});
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new CSVParser(Optional.fromNullable((Object)this.listDelimiter), this.columns);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new CSVParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new CSVParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns);
    }

    public ParseSpec withColumns(List<String> cols) {
        return new CSVParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.listDelimiter, cols);
    }
}

