/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.metamx.common.parsers.ParserUtils;
import io.druid.data.input.impl.SpatialDimensionSchema;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DimensionsSpec {
    private final List<String> dimensions;
    private final Set<String> dimensionExclusions;
    private final List<SpatialDimensionSchema> spatialDimensions;

    @JsonCreator
    public DimensionsSpec(@JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        this.dimensions = dimensions == null ? Lists.newArrayList() : Lists.newArrayList(dimensions);
        Collections.sort(this.dimensions, Ordering.natural().nullsFirst());
        this.dimensionExclusions = dimensionExclusions == null ? Sets.newHashSet() : Sets.newHashSet(dimensionExclusions);
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
        this.verify();
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }

    @JsonProperty
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public DimensionsSpec withDimensions(List<String> dims) {
        return new DimensionsSpec(dims, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), this.spatialDimensions);
    }

    public DimensionsSpec withDimensionExclusions(Set<String> dimExs) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf((Collection)Sets.union(this.dimensionExclusions, dimExs)), this.spatialDimensions);
    }

    public DimensionsSpec withSpatialDimensions(List<SpatialDimensionSchema> spatials) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), spatials);
    }

    private void verify() {
        Preconditions.checkArgument((boolean)Sets.intersection(this.dimensionExclusions, (Set)Sets.newHashSet(this.dimensions)).isEmpty(), (Object)"dimensions and dimensions exclusions cannot overlap");
        ParserUtils.validateFields(this.dimensions);
        ParserUtils.validateFields(this.dimensionExclusions);
        ParserUtils.validateFields((Iterable)Iterables.transform(this.spatialDimensions, (Function)new Function<SpatialDimensionSchema, String>(){

            public String apply(SpatialDimensionSchema input) {
                return input.getDimName();
            }
        }));
    }
}

