/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.metamx.common.parsers.ParserUtils;
import java.util.Map;
import org.joda.time.DateTime;

public class TimestampSpec {
    private static final String DEFAULT_COLUMN = "timestamp";
    private static final String DEFAULT_FORMAT = "auto";
    private static final DateTime MISSING_VALUE = null;
    private final String timestampColumn;
    private final String timestampFormat;
    private final Function<String, DateTime> timestampConverter;
    private final DateTime missingValue;

    @JsonCreator
    public TimestampSpec(@JsonProperty(value="column") String timestampColumn, @JsonProperty(value="format") String format, @JsonProperty(value="missingValue") DateTime missingValue) {
        this.timestampColumn = timestampColumn == null ? DEFAULT_COLUMN : timestampColumn;
        this.timestampFormat = format == null ? DEFAULT_FORMAT : format;
        this.timestampConverter = ParserUtils.createTimestampParser((String)this.timestampFormat);
        this.missingValue = missingValue == null ? MISSING_VALUE : missingValue;
    }

    @JsonProperty(value="column")
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    @JsonProperty(value="format")
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @JsonProperty(value="missingValue")
    public DateTime getMissingValue() {
        return this.missingValue;
    }

    public DateTime extractTimestamp(Map<String, Object> input) {
        Object o = input.get(this.timestampColumn);
        return o == null ? this.missingValue : (DateTime)this.timestampConverter.apply((Object)o.toString());
    }
}

