/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.base.Strings;
import io.druid.common.aws.AWSCredentialsConfig;

public class ConfigDrivenAwsCredentialsConfigProvider
implements AWSCredentialsProvider {
    private AWSCredentialsConfig config;

    public ConfigDrivenAwsCredentialsConfigProvider(AWSCredentialsConfig config) {
        this.config = config;
    }

    public AWSCredentials getCredentials() {
        final String key = this.config.getAccessKey().getPassword();
        final String secret = this.config.getSecretKey().getPassword();
        if (!Strings.isNullOrEmpty((String)key) && !Strings.isNullOrEmpty((String)secret)) {
            return new AWSCredentials(){

                public String getAWSAccessKeyId() {
                    return key;
                }

                public String getAWSSecretKey() {
                    return secret;
                }
            };
        }
        throw new AmazonClientException("Unable to load AWS credentials from druid AWSCredentialsConfig");
    }

    public void refresh() {
    }
}

