/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import io.druid.java.util.common.concurrent.Execs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FileSessionCredentialsProvider
implements AWSCredentialsProvider {
    private final String sessionCredentials;
    private volatile String sessionToken;
    private volatile String accessKey;
    private volatile String secretKey;
    private final ScheduledExecutorService scheduler = Execs.scheduledSingleThreaded((String)"FileSessionCredentialsProviderRefresh-%d");

    public FileSessionCredentialsProvider(String sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
        this.refresh();
        this.scheduler.scheduleAtFixedRate(this::refresh, 1L, 1L, TimeUnit.HOURS);
    }

    public AWSCredentials getCredentials() {
        return new AWSSessionCredentials(){

            public String getSessionToken() {
                return FileSessionCredentialsProvider.this.sessionToken;
            }

            public String getAWSAccessKeyId() {
                return FileSessionCredentialsProvider.this.accessKey;
            }

            public String getAWSSecretKey() {
                return FileSessionCredentialsProvider.this.secretKey;
            }
        };
    }

    public void refresh() {
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(new File(this.sessionCredentials));
            props.load(is);
            ((InputStream)is).close();
            this.sessionToken = props.getProperty("sessionToken");
            this.accessKey = props.getProperty("accessKey");
            this.secretKey = props.getProperty("secretKey");
        }
        catch (IOException e) {
            throw new RuntimeException("cannot refresh AWS credentials", e);
        }
    }
}

