/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.base.Strings;
import io.druid.common.aws.AWSCredentialsConfig;

public class ConfigDrivenAwsCredentialsConfigProvider
implements AWSCredentialsProvider {
    private AWSCredentialsConfig config;

    public ConfigDrivenAwsCredentialsConfigProvider(AWSCredentialsConfig config) {
        this.config = config;
    }

    public AWSCredentials getCredentials() {
        if (!Strings.isNullOrEmpty((String)this.config.getAccessKey()) && !Strings.isNullOrEmpty((String)this.config.getSecretKey())) {
            return new AWSCredentials(){

                public String getAWSAccessKeyId() {
                    return ConfigDrivenAwsCredentialsConfigProvider.this.config.getAccessKey();
                }

                public String getAWSSecretKey() {
                    return ConfigDrivenAwsCredentialsConfigProvider.this.config.getSecretKey();
                }
            };
        }
        throw new AmazonClientException("Unable to load AWS credentials from druid AWSCredentialsConfig");
    }

    public void refresh() {
    }
}

