/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.metamx.common.guava.MergeIterable;
import com.metamx.common.guava.nary.BinaryFn;
import io.druid.collections.CombiningIterator;
import java.util.Comparator;
import java.util.Iterator;

public class CombiningIterable<InType>
implements Iterable<InType> {
    private final Iterable<InType> it;
    private final Comparator<InType> comparator;
    private final BinaryFn<InType, InType, InType> fn;

    public static <InType> CombiningIterable<InType> createSplatted(Iterable<? extends Iterable<InType>> in, Comparator<InType> comparator) {
        return CombiningIterable.create(new MergeIterable(comparator, in), comparator, new BinaryFn<InType, InType, InType>(){

            public InType apply(InType arg1, InType arg2) {
                if (arg1 == null) {
                    return arg2;
                }
                return arg1;
            }
        });
    }

    public static <InType> CombiningIterable<InType> create(Iterable<InType> it, Comparator<InType> comparator, BinaryFn<InType, InType, InType> fn) {
        return new CombiningIterable<InType>(it, comparator, fn);
    }

    public CombiningIterable(Iterable<InType> it, Comparator<InType> comparator, BinaryFn<InType, InType, InType> fn) {
        this.it = it;
        this.comparator = comparator;
        this.fn = fn;
    }

    @Override
    public Iterator<InType> iterator() {
        return CombiningIterator.create(this.it.iterator(), this.comparator, this.fn);
    }
}

