/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import java.nio.IntBuffer;
import java.util.ArrayList;

public class IntList {
    private final ArrayList<int[]> baseLists = new ArrayList();
    private final int allocateSize;
    private int maxIndex;

    public IntList() {
        this(1000);
    }

    public IntList(int allocateSize) {
        this.allocateSize = allocateSize;
        this.maxIndex = -1;
    }

    public int length() {
        return this.maxIndex + 1;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public void add(int value) {
        this.set(this.length(), value);
    }

    public void set(int index, int value) {
        int[] baseList;
        int subListIndex = index / this.allocateSize;
        if (subListIndex >= this.baseLists.size()) {
            for (int i = this.baseLists.size(); i <= subListIndex; ++i) {
                this.baseLists.add(null);
            }
        }
        if ((baseList = this.baseLists.get(subListIndex)) == null) {
            baseList = new int[this.allocateSize];
            this.baseLists.set(subListIndex, baseList);
        }
        baseList[index % this.allocateSize] = value;
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
    }

    public int get(int index) {
        if (index > this.maxIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subListIndex = index / this.allocateSize;
        int[] baseList = this.baseLists.get(subListIndex);
        if (baseList == null) {
            return 0;
        }
        return baseList[index % this.allocateSize];
    }

    public int baseListCount() {
        return this.baseLists.size();
    }

    public IntBuffer getBaseList(int index) {
        int[] array = this.baseLists.get(index);
        if (array == null) {
            return null;
        }
        IntBuffer retVal = IntBuffer.wrap(array);
        if (index + 1 == this.baseListCount()) {
            retVal.limit(this.maxIndex - index * this.allocateSize + 1);
        }
        return retVal.asReadOnlyBuffer();
    }

    public int[] toArray() {
        int[] retVal = new int[this.length()];
        int currIndex = 0;
        for (int[] arr : this.baseLists) {
            int min = Math.min(this.length() - currIndex, arr.length);
            System.arraycopy(arr, 0, retVal, currIndex, min);
            currIndex += min;
        }
        return retVal;
    }
}

