/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.metamx.common.logger.Logger;
import io.druid.collections.ResourceHolder;
import java.io.IOException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class LoadBalancingPool<T>
implements Supplier<ResourceHolder<T>> {
    private static final Logger log = new Logger(LoadBalancingPool.class);
    private final Supplier<T> generator;
    private final int capacity;
    private final PriorityBlockingQueue<CountingHolder> queue;

    public LoadBalancingPool(int capacity, Supplier<T> generator) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be greater than 0");
        Preconditions.checkNotNull(generator);
        this.generator = generator;
        this.capacity = capacity;
        this.queue = new PriorityBlockingQueue(capacity);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.capacity; ++i) {
            this.queue.offer(new CountingHolder(this.generator.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHolder<T> get() {
        CountingHolder holder;
        try {
            holder = this.queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        CountingHolder countingHolder = holder;
        synchronized (countingHolder) {
            holder.count.incrementAndGet();
            this.queue.offer(holder);
        }
        return holder;
    }

    private class CountingHolder
    implements ResourceHolder<T>,
    Comparable<CountingHolder> {
        private AtomicInteger count = new AtomicInteger(0);
        private final T object;

        public CountingHolder(T object) {
            this.object = object;
        }

        @Override
        public T get() {
            return this.object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CountingHolder countingHolder = this;
            synchronized (countingHolder) {
                boolean removed = LoadBalancingPool.this.queue.remove(this);
                this.count.decrementAndGet();
                if (removed) {
                    LoadBalancingPool.this.queue.offer(this);
                }
            }
        }

        @Override
        public int compareTo(CountingHolder o) {
            return Integer.compare(this.count.get(), o.count.get());
        }

        protected void finalize() throws Throwable {
            try {
                int shouldBeZero = this.count.get();
                if (shouldBeZero != 0) {
                    log.warn("Expected 0 resource count, got [%d]! Object was[%s].", new Object[]{shouldBeZero, this.object});
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

