/*
 * Decompiled with CFR 0.152.
 */
package io.druid.common.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.UUID;

public class UUIDUtils {
    public static final String UUID_DELIM = "_";

    public static String generateUuid(String ... extraData) {
        String extra = null;
        if (extraData != null && extraData.length > 0) {
            ArrayList<String> extraStrings = new ArrayList<String>(extraData.length);
            for (String extraString : extraData) {
                if (Strings.isNullOrEmpty((String)extraString)) continue;
                extraStrings.add(extraString);
            }
            if (!extraStrings.isEmpty()) {
                extra = Joiner.on((String)UUID_DELIM).join(extraStrings);
            }
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return extra == null ? uuid : extra + UUID_DELIM + uuid;
    }
}

