/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.math.expr.Expr;
import java.util.Map;

class UnaryMinusExpr
implements Expr {
    private final Expr expr;

    UnaryMinusExpr(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Number eval(Map<String, Number> bindings) {
        Number valObj = this.expr.eval(bindings);
        if (valObj instanceof Long) {
            return -1L * valObj.longValue();
        }
        return -1.0 * valObj.doubleValue();
    }

    public String toString() {
        return "-" + this.expr.toString();
    }
}

