/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.granularity.QueryGranularity;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.annotations.Self;
import io.druid.indexer.Bucket;
import io.druid.indexer.HadoopIngestionSpec;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.IndexingHadoopModule;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.path.PathSpec;
import io.druid.initialization.Initialization;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.server.DruidNode;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class HadoopDruidIndexerConfig {
    private static final Logger log = new Logger(HadoopDruidIndexerConfig.class);
    private static final Injector injector;
    public static final String CONFIG_PROPERTY = "druid.indexer.config";
    public static final Charset JAVA_NATIVE_CHARSET;
    public static final Splitter TAB_SPLITTER;
    public static final Joiner TAB_JOINER;
    public static final ObjectMapper JSON_MAPPER;
    public static final IndexIO INDEX_IO;
    public static final IndexMerger INDEX_MERGER;
    public static final IndexMergerV9 INDEX_MERGER_V9;
    private static final String DEFAULT_WORKING_PATH = "/tmp/druid-indexing";
    private volatile HadoopIngestionSpec schema;
    private volatile PathSpec pathSpec;
    private final Map<DateTime, ShardSpecLookup> shardSpecLookups = Maps.newHashMap();
    private final Map<DateTime, Map<ShardSpec, HadoopyShardSpec>> hadoopShardSpecLookup = Maps.newHashMap();
    private final QueryGranularity rollupGran;

    public static HadoopDruidIndexerConfig fromSpec(HadoopIngestionSpec spec) {
        return new HadoopDruidIndexerConfig(spec);
    }

    public static HadoopDruidIndexerConfig fromMap(Map<String, Object> argSpec) {
        if (argSpec.containsKey("spec")) {
            return (HadoopDruidIndexerConfig)JSON_MAPPER.convertValue(argSpec, HadoopDruidIndexerConfig.class);
        }
        return new HadoopDruidIndexerConfig((HadoopIngestionSpec)((Object)JSON_MAPPER.convertValue(argSpec, HadoopIngestionSpec.class)));
    }

    public static HadoopDruidIndexerConfig fromFile(File file) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromString(String str) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue(str, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromDistributedFileSystem(String path) {
        try {
            Path pt = new Path(path);
            FileSystem fs = pt.getFileSystem(new Configuration());
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(pt));
            return HadoopDruidIndexerConfig.fromMap((Map)JSON_MAPPER.readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromConfiguration(Configuration conf) {
        HadoopDruidIndexerConfig retVal = HadoopDruidIndexerConfig.fromString(conf.get(CONFIG_PROPERTY));
        retVal.verify();
        return retVal;
    }

    @JsonCreator
    public HadoopDruidIndexerConfig(@JsonProperty(value="spec") HadoopIngestionSpec spec) {
        this.schema = spec;
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(spec.getIOConfig().getPathSpec(), PathSpec.class);
        for (Map.Entry<DateTime, List<HadoopyShardSpec>> entry : spec.getTuningConfig().getShardSpecs().entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            ShardSpec actualSpec = entry.getValue().get(0).getActualSpec();
            this.shardSpecLookups.put(entry.getKey(), actualSpec.getLookup(Lists.transform(entry.getValue(), (Function)new Function<HadoopyShardSpec, ShardSpec>(){

                public ShardSpec apply(HadoopyShardSpec input) {
                    return input.getActualSpec();
                }
            })));
            HashMap innerHadoopShardSpecLookup = Maps.newHashMap();
            for (HadoopyShardSpec hadoopyShardSpec : entry.getValue()) {
                innerHadoopShardSpecLookup.put(hadoopyShardSpec.getActualSpec(), hadoopyShardSpec);
            }
            this.hadoopShardSpecLookup.put(entry.getKey(), innerHadoopShardSpecLookup);
        }
        this.rollupGran = spec.getDataSchema().getGranularitySpec().getQueryGranularity();
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSchema() {
        return this.schema;
    }

    @JsonIgnore
    public PathSpec getPathSpec() {
        return this.pathSpec;
    }

    public String getDataSource() {
        return this.schema.getDataSchema().getDataSource();
    }

    public GranularitySpec getGranularitySpec() {
        return this.schema.getDataSchema().getGranularitySpec();
    }

    public void setGranularitySpec(GranularitySpec granularitySpec) {
        this.schema = this.schema.withDataSchema(this.schema.getDataSchema().withGranularitySpec(granularitySpec));
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public PartitionsSpec getPartitionsSpec() {
        return this.schema.getTuningConfig().getPartitionsSpec();
    }

    public IndexSpec getIndexSpec() {
        return this.schema.getTuningConfig().getIndexSpec();
    }

    public boolean isOverwriteFiles() {
        return this.schema.getTuningConfig().isOverwriteFiles();
    }

    public boolean isIgnoreInvalidRows() {
        return this.schema.getTuningConfig().isIgnoreInvalidRows();
    }

    public void setVersion(String version) {
        this.schema = this.schema.withTuningConfig(this.schema.getTuningConfig().withVersion(version));
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public void setShardSpecs(Map<DateTime, List<HadoopyShardSpec>> shardSpecs) {
        this.schema = this.schema.withTuningConfig(this.schema.getTuningConfig().withShardSpecs(shardSpecs));
        this.pathSpec = (PathSpec)JSON_MAPPER.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public Optional<List<Interval>> getIntervals() {
        Optional setOptional = this.schema.getDataSchema().getGranularitySpec().bucketIntervals();
        if (setOptional.isPresent()) {
            return Optional.of((Object)JodaUtils.condenseIntervals((Iterable)((Iterable)setOptional.get())));
        }
        return Optional.absent();
    }

    public boolean isDeterminingPartitions() {
        return this.schema.getTuningConfig().getPartitionsSpec().isDeterminingPartitions();
    }

    public Long getTargetPartitionSize() {
        return this.schema.getTuningConfig().getPartitionsSpec().getTargetPartitionSize();
    }

    public long getMaxPartitionSize() {
        return this.schema.getTuningConfig().getPartitionsSpec().getMaxPartitionSize();
    }

    public boolean isUpdaterJobSpecSet() {
        return this.schema.getIOConfig().getMetadataUpdateSpec() != null;
    }

    public boolean isCombineText() {
        return this.schema.getTuningConfig().isCombineText();
    }

    public InputRowParser getParser() {
        return this.schema.getDataSchema().getParser();
    }

    public HadoopyShardSpec getShardSpec(Bucket bucket) {
        return this.schema.getTuningConfig().getShardSpecs().get(bucket.time).get(bucket.partitionNum);
    }

    public boolean isBuildV9Directly() {
        return this.schema.getTuningConfig().getBuildV9Directly();
    }

    public Job addInputPaths(Job job) throws IOException {
        return this.pathSpec.addInputPaths(this, job);
    }

    public Optional<Bucket> getBucket(InputRow inputRow) {
        Optional timeBucket = this.schema.getDataSchema().getGranularitySpec().bucketInterval(new DateTime(inputRow.getTimestampFromEpoch()));
        if (!timeBucket.isPresent()) {
            return Optional.absent();
        }
        DateTime bucketStart = ((Interval)timeBucket.get()).getStart();
        ShardSpec actualSpec = this.shardSpecLookups.get(bucketStart).getShardSpec(this.rollupGran.truncate(inputRow.getTimestampFromEpoch()), inputRow);
        HadoopyShardSpec hadoopyShardSpec = this.hadoopShardSpecLookup.get(bucketStart).get(actualSpec);
        return Optional.of((Object)new Bucket(hadoopyShardSpec.getShardNum(), bucketStart, actualSpec.getPartitionNum()));
    }

    public Optional<Set<Interval>> getSegmentGranularIntervals() {
        return Optional.fromNullable((Object)((Set)this.schema.getDataSchema().getGranularitySpec().bucketIntervals().orNull()));
    }

    public Optional<Iterable<Bucket>> getAllBuckets() {
        Optional<Set<Interval>> intervals = this.getSegmentGranularIntervals();
        if (intervals.isPresent()) {
            return Optional.of((Object)FunctionalIterable.create((Iterable)((Iterable)intervals.get())).transformCat((Function)new Function<Interval, Iterable<Bucket>>(){

                public Iterable<Bucket> apply(Interval input) {
                    final DateTime bucketTime = input.getStart();
                    List<HadoopyShardSpec> specs = HadoopDruidIndexerConfig.this.schema.getTuningConfig().getShardSpecs().get(bucketTime);
                    if (specs == null) {
                        return ImmutableList.of();
                    }
                    return FunctionalIterable.create(specs).transform((Function)new Function<HadoopyShardSpec, Bucket>(){
                        int i = 0;

                        public Bucket apply(HadoopyShardSpec input) {
                            return new Bucket(input.getShardNum(), bucketTime, this.i++);
                        }
                    });
                }
            }));
        }
        return Optional.absent();
    }

    public String getWorkingPath() {
        String workingPath = this.schema.getTuningConfig().getWorkingPath();
        return workingPath == null ? DEFAULT_WORKING_PATH : workingPath;
    }

    public Path makeIntermediatePath() {
        return new Path(String.format("%s/%s/%s/%s", this.getWorkingPath(), this.schema.getDataSchema().getDataSource(), this.schema.getTuningConfig().getVersion().replace(":", ""), this.schema.getUniqueId()));
    }

    public Path makeSegmentPartitionInfoPath(Interval bucketInterval) {
        return new Path(String.format("%s/%s_%s/partitions.json", this.makeIntermediatePath(), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getStart()), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getEnd())));
    }

    public Path makeIntervalInfoPath() {
        return new Path(String.format("%s/intervals.json", this.makeIntermediatePath()));
    }

    public Path makeDescriptorInfoDir() {
        return new Path(this.makeIntermediatePath(), "segmentDescriptorInfo");
    }

    public Path makeGroupedDataDir() {
        return new Path(this.makeIntermediatePath(), "groupedData");
    }

    public Path makeDescriptorInfoPath(DataSegment segment) {
        return new Path(this.makeDescriptorInfoDir(), String.format("%s.json", segment.getIdentifier().replace(":", "")));
    }

    public void addJobProperties(Job job) {
        Configuration conf = job.getConfiguration();
        for (Map.Entry<String, String> entry : this.schema.getTuningConfig().getJobProperties().entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    public void intoConfiguration(Job job) {
        Configuration conf = job.getConfiguration();
        try {
            conf.set(CONFIG_PROPERTY, JSON_MAPPER.writeValueAsString((Object)this));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void verify() {
        try {
            log.info("Running with config:%n%s", new Object[]{JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this)});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getDataSource(), (Object)"dataSource");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser().getParseSpec(), (Object)"parseSpec");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser().getParseSpec().getTimestampSpec(), (Object)"timestampSpec");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getGranularitySpec(), (Object)"granularitySpec");
        Preconditions.checkNotNull((Object)this.pathSpec, (Object)"inputSpec");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getWorkingPath(), (Object)"workingPath");
        Preconditions.checkNotNull((Object)this.schema.getIOConfig().getSegmentOutputPath(), (Object)"segmentOutputPath");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getVersion(), (Object)"version");
    }

    static {
        JAVA_NATIVE_CHARSET = Charset.forName("Unicode");
        TAB_SPLITTER = Splitter.on((String)"\t");
        TAB_JOINER = Joiner.on((String)"\t");
        injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("hadoop-indexer", null, null));
            }
        }, (Object)new IndexingHadoopModule()));
        JSON_MAPPER = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        INDEX_IO = (IndexIO)injector.getInstance(IndexIO.class);
        INDEX_MERGER = (IndexMerger)injector.getInstance(IndexMerger.class);
        INDEX_MERGER_V9 = (IndexMergerV9)injector.getInstance(IndexMergerV9.class);
    }

    public static enum IndexJobCounters {
        INVALID_ROW_COUNTER;

    }
}

