/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.metamx.common.RE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.joda.time.DateTime;

public abstract class HadoopDruidIndexerMapper<KEYOUT, VALUEOUT>
extends Mapper<Object, Object, KEYOUT, VALUEOUT> {
    private static final Logger log = new Logger(HadoopDruidIndexerMapper.class);
    protected HadoopDruidIndexerConfig config;
    private InputRowParser parser;
    protected GranularitySpec granularitySpec;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
        this.parser = this.config.getParser();
        this.granularitySpec = this.config.getGranularitySpec();
    }

    public HadoopDruidIndexerConfig getConfig() {
        return this.config;
    }

    public InputRowParser getParser() {
        return this.parser;
    }

    protected void map(Object key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            InputRow inputRow;
            try {
                inputRow = HadoopDruidIndexerMapper.parseInputRow(value, this.parser);
            }
            catch (Exception e) {
                if (this.config.isIgnoreInvalidRows()) {
                    log.debug((Throwable)e, "Ignoring invalid row [%s] due to parsing error", new Object[]{value.toString()});
                    context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER).increment(1L);
                    return;
                }
                throw e;
            }
            if (!this.granularitySpec.bucketIntervals().isPresent() || this.granularitySpec.bucketInterval(new DateTime(inputRow.getTimestampFromEpoch())).isPresent()) {
                this.innerMap(inputRow, value, context);
            }
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "Failure on row[%s]", new Object[]{value});
        }
    }

    public static final InputRow parseInputRow(Object value, InputRowParser parser) {
        if (parser instanceof StringInputRowParser && value instanceof Text) {
            return ((StringInputRowParser)parser).parse(value.toString());
        }
        if (value instanceof InputRow) {
            return (InputRow)value;
        }
        return parser.parse(value);
    }

    protected abstract void innerMap(InputRow var1, Object var2, Mapper.Context var3) throws IOException, InterruptedException;
}

