/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.partitions.HashedPartitionsSpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.TuningConfig;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@JsonTypeName(value="hadoop")
public class HadoopTuningConfig
implements TuningConfig {
    private static final PartitionsSpec DEFAULT_PARTITIONS_SPEC = HashedPartitionsSpec.makeDefaultHashedPartitionsSpec();
    private static final Map<DateTime, List<HadoopyShardSpec>> DEFAULT_SHARD_SPECS = ImmutableMap.of();
    private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
    private static final int DEFAULT_ROW_FLUSH_BOUNDARY = 75000;
    private static final boolean DEFAULT_USE_COMBINER = false;
    private static final Boolean DEFAULT_BUILD_V9_DIRECTLY = Boolean.FALSE;
    private static final int DEFAULT_NUM_BACKGROUND_PERSIST_THREADS = 0;
    private final String workingPath;
    private final String version;
    private final PartitionsSpec partitionsSpec;
    private final Map<DateTime, List<HadoopyShardSpec>> shardSpecs;
    private final IndexSpec indexSpec;
    private final int rowFlushBoundary;
    private final boolean leaveIntermediate;
    private final Boolean cleanupOnFailure;
    private final boolean overwriteFiles;
    private final boolean ignoreInvalidRows;
    private final Map<String, String> jobProperties;
    private final boolean combineText;
    private final boolean useCombiner;
    private final Boolean buildV9Directly;
    private final int numBackgroundPersistThreads;

    public static HadoopTuningConfig makeDefaultTuningConfig() {
        return new HadoopTuningConfig(null, new DateTime().toString(), DEFAULT_PARTITIONS_SPEC, DEFAULT_SHARD_SPECS, DEFAULT_INDEX_SPEC, 75000, false, true, false, false, null, false, false, null, DEFAULT_BUILD_V9_DIRECTLY, 0);
    }

    @JsonCreator
    public HadoopTuningConfig(@JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="shardSpecs") Map<DateTime, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @JsonProperty(value="ignoreInvalidRows") boolean ignoreInvalidRows, @JsonProperty(value="jobProperties") Map<String, String> jobProperties, @JsonProperty(value="combineText") boolean combineText, @JsonProperty(value="useCombiner") Boolean useCombiner, @JsonProperty(value="rowFlushBoundary") Integer maxRowsInMemoryCOMPAT, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="numBackgroundPersistThreads") Integer numBackgroundPersistThreads) {
        this.workingPath = workingPath;
        this.version = version == null ? new DateTime().toString() : version;
        this.partitionsSpec = partitionsSpec == null ? DEFAULT_PARTITIONS_SPEC : partitionsSpec;
        this.shardSpecs = shardSpecs == null ? DEFAULT_SHARD_SPECS : shardSpecs;
        IndexSpec indexSpec2 = this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
        this.rowFlushBoundary = maxRowsInMemory == null ? (maxRowsInMemoryCOMPAT == null ? 75000 : maxRowsInMemoryCOMPAT) : maxRowsInMemory;
        this.leaveIntermediate = leaveIntermediate;
        this.cleanupOnFailure = cleanupOnFailure == null ? true : cleanupOnFailure;
        this.overwriteFiles = overwriteFiles;
        this.ignoreInvalidRows = ignoreInvalidRows;
        this.jobProperties = jobProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(jobProperties);
        this.combineText = combineText;
        this.useCombiner = useCombiner == null ? false : useCombiner;
        this.buildV9Directly = buildV9Directly == null ? DEFAULT_BUILD_V9_DIRECTLY : buildV9Directly;
        this.numBackgroundPersistThreads = numBackgroundPersistThreads == null ? 0 : numBackgroundPersistThreads;
        Preconditions.checkArgument((this.numBackgroundPersistThreads >= 0 ? 1 : 0) != 0, (Object)"Not support persistBackgroundCount < 0");
    }

    @JsonProperty
    public String getWorkingPath() {
        return this.workingPath;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public Map<DateTime, List<HadoopyShardSpec>> getShardSpecs() {
        return this.shardSpecs;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty(value="maxRowsInMemory")
    public int getRowFlushBoundary() {
        return this.rowFlushBoundary;
    }

    @JsonProperty
    public boolean isLeaveIntermediate() {
        return this.leaveIntermediate;
    }

    @JsonProperty
    public Boolean isCleanupOnFailure() {
        return this.cleanupOnFailure;
    }

    @JsonProperty
    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    @JsonProperty
    public boolean isIgnoreInvalidRows() {
        return this.ignoreInvalidRows;
    }

    @JsonProperty
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    @JsonProperty
    public boolean isCombineText() {
        return this.combineText;
    }

    @JsonProperty
    public boolean getUseCombiner() {
        return this.useCombiner;
    }

    @JsonProperty
    public Boolean getBuildV9Directly() {
        return this.buildV9Directly;
    }

    @JsonProperty
    public int getNumBackgroundPersistThreads() {
        return this.numBackgroundPersistThreads;
    }

    public HadoopTuningConfig withWorkingPath(String path) {
        return new HadoopTuningConfig(path, this.version, this.partitionsSpec, this.shardSpecs, this.indexSpec, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, this.buildV9Directly, this.numBackgroundPersistThreads);
    }

    public HadoopTuningConfig withVersion(String ver) {
        return new HadoopTuningConfig(this.workingPath, ver, this.partitionsSpec, this.shardSpecs, this.indexSpec, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, this.buildV9Directly, this.numBackgroundPersistThreads);
    }

    public HadoopTuningConfig withShardSpecs(Map<DateTime, List<HadoopyShardSpec>> specs) {
        return new HadoopTuningConfig(this.workingPath, this.version, this.partitionsSpec, specs, this.indexSpec, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, this.buildV9Directly, this.numBackgroundPersistThreads);
    }
}

