/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import io.druid.indexer.Utils;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;

class HadoopIOPeon
implements IOPeon {
    private final JobContext job;
    private final Path baseDir;
    private final boolean overwriteFiles;

    public HadoopIOPeon(JobContext job, Path baseDir, boolean overwriteFiles) {
        this.job = job;
        this.baseDir = baseDir;
        this.overwriteFiles = overwriteFiles;
    }

    public OutputStream makeOutputStream(String filename) throws IOException {
        return Utils.makePathAndOutputStream(this.job, new Path(this.baseDir, filename), this.overwriteFiles);
    }

    public InputStream makeInputStream(String filename) throws IOException {
        return Utils.openInputStream(this.job, new Path(this.baseDir, filename));
    }

    public void cleanup() throws IOException {
        throw new UnsupportedOperationException();
    }
}

