/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.IAE;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringInputRowParser;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class HadoopyStringInputRowParser
implements InputRowParser<Object> {
    private final StringInputRowParser parser;

    public HadoopyStringInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parser = new StringInputRowParser(parseSpec, null);
    }

    public InputRow parse(Object input) {
        if (input instanceof Text) {
            return this.parser.parse(((Text)input).toString());
        }
        if (input instanceof BytesWritable) {
            BytesWritable valueBytes = (BytesWritable)input;
            return this.parser.parse(ByteBuffer.wrap(valueBytes.getBytes(), 0, valueBytes.getLength()));
        }
        throw new IAE("can't convert type [%s] to InputRow", new Object[]{input.getClass().getName()});
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parser.getParseSpec();
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new HadoopyStringInputRowParser(parseSpec);
    }
}

