/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.common.guava.ThreadRenamingRunnable;
import io.druid.concurrent.Execs;
import io.druid.data.input.InputRow;
import io.druid.data.input.Row;
import io.druid.data.input.Rows;
import io.druid.indexer.Bucket;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerMapper;
import io.druid.indexer.HadoopTuningConfig;
import io.druid.indexer.InputRowSerde;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.indexer.SortableBytes;
import io.druid.indexer.hadoop.SegmentInputRow;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.BaseProgressIndicator;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.QueryableIndex;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IndexGeneratorJob
implements Jobby {
    private static final Logger log = new Logger(IndexGeneratorJob.class);
    private final HadoopDruidIndexerConfig config;
    private IndexGeneratorStats jobStats;

    public static List<DataSegment> getPublishedSegments(HadoopDruidIndexerConfig config) {
        Configuration conf = JobHelper.injectSystemProperties(new Configuration());
        ObjectMapper jsonMapper = HadoopDruidIndexerConfig.JSON_MAPPER;
        ImmutableList.Builder publishedSegmentsBuilder = ImmutableList.builder();
        Path descriptorInfoDir = config.makeDescriptorInfoDir();
        try {
            FileSystem fs = descriptorInfoDir.getFileSystem(conf);
            for (FileStatus status : fs.listStatus(descriptorInfoDir)) {
                DataSegment segment = (DataSegment)jsonMapper.readValue((InputStream)fs.open(status.getPath()), DataSegment.class);
                publishedSegmentsBuilder.add((Object)segment);
                log.info("Adding segment %s to the list of published segments", new Object[]{segment.getIdentifier()});
            }
        }
        catch (FileNotFoundException e) {
            log.error("[%s] SegmentDescriptorInfo is not found usually when indexing process did not produce any segments meaning either there was no input data to process or all the input events were discarded due to some error", new Object[]{e.getMessage()});
            Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableList publishedSegments = publishedSegmentsBuilder.build();
        return publishedSegments;
    }

    public IndexGeneratorJob(HadoopDruidIndexerConfig config) {
        this.config = config;
        this.jobStats = new IndexGeneratorStats();
    }

    protected void setReducerClass(Job job) {
        job.setReducerClass(IndexGeneratorReducer.class);
    }

    public IndexGeneratorStats getJobStats() {
        return this.jobStats;
    }

    public boolean run() {
        try {
            Job job = Job.getInstance((Configuration)new Configuration(), (String)String.format("%s-index-generator-%s", this.config.getDataSource(), this.config.getIntervals()));
            job.getConfiguration().set("io.sort.record.percent", "0.23");
            JobHelper.injectSystemProperties(job);
            this.config.addJobProperties(job);
            job.setMapperClass(IndexGeneratorMapper.class);
            job.setMapOutputValueClass(BytesWritable.class);
            SortableBytes.useSortableBytesAsMapOutputKey(job);
            int numReducers = Iterables.size((Iterable)((Iterable)this.config.getAllBuckets().get()));
            if (numReducers == 0) {
                throw new RuntimeException("No buckets?? seems there is no data to index.");
            }
            if (this.config.getSchema().getTuningConfig().getUseCombiner()) {
                job.setCombinerClass(IndexGeneratorCombiner.class);
                job.setCombinerKeyGroupingComparatorClass(BytesWritable.Comparator.class);
            }
            job.setNumReduceTasks(numReducers);
            job.setPartitionerClass(IndexGeneratorPartitioner.class);
            this.setReducerClass(job);
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(Text.class);
            job.setOutputFormatClass(IndexGeneratorOutputFormat.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)this.config.makeIntermediatePath());
            this.config.addInputPaths(job);
            this.config.intoConfiguration(job);
            JobHelper.setupClasspath(JobHelper.distributedClassPath(this.config.getWorkingPath()), JobHelper.distributedClassPath(this.config.makeIntermediatePath()), job);
            job.submit();
            log.info("Job %s submitted, status available at %s", new Object[]{job.getJobName(), job.getTrackingURL()});
            boolean success = job.waitForCompletion(true);
            Counter invalidRowCount = job.getCounters().findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER);
            this.jobStats.setInvalidRowCount(invalidRowCount.getValue());
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IncrementalIndex makeIncrementalIndex(Bucket theBucket, AggregatorFactory[] aggs, HadoopDruidIndexerConfig config, Iterable<String> oldDimOrder, Map<String, ColumnCapabilitiesImpl> oldCapabilities) {
        HadoopTuningConfig tuningConfig = config.getSchema().getTuningConfig();
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMinTimestamp(theBucket.time.getMillis()).withTimestampSpec(config.getSchema().getDataSchema().getParser().getParseSpec().getTimestampSpec()).withDimensionsSpec(config.getSchema().getDataSchema().getParser()).withQueryGranularity(config.getSchema().getDataSchema().getGranularitySpec().getQueryGranularity()).withMetrics(aggs).withRollup(config.getSchema().getDataSchema().getGranularitySpec().isRollup()).build();
        OnheapIncrementalIndex newIndex = new OnheapIncrementalIndex(indexSchema, !tuningConfig.isIgnoreInvalidRows(), tuningConfig.getRowFlushBoundary());
        if (oldDimOrder != null && !indexSchema.getDimensionsSpec().hasCustomDimensions()) {
            newIndex.loadDimensionIterable(oldDimOrder, oldCapabilities);
        }
        return newIndex;
    }

    public static class IndexGeneratorStats {
        private long invalidRowCount = 0L;

        public long getInvalidRowCount() {
            return this.invalidRowCount;
        }

        public void setInvalidRowCount(long invalidRowCount) {
            this.invalidRowCount = invalidRowCount;
        }
    }

    public static class IndexGeneratorOutputFormat
    extends TextOutputFormat {
        public void checkOutputSpecs(JobContext job) throws IOException {
            Path outDir = IndexGeneratorOutputFormat.getOutputPath((JobContext)job);
            if (outDir == null) {
                throw new InvalidJobConfException("Output directory not set.");
            }
        }
    }

    public static class IndexGeneratorReducer
    extends Reducer<BytesWritable, BytesWritable, BytesWritable, Text> {
        protected HadoopDruidIndexerConfig config;
        private List<String> metricNames = Lists.newArrayList();
        private AggregatorFactory[] aggregators;
        private AggregatorFactory[] combiningAggs;

        protected ProgressIndicator makeProgressIndicator(final Reducer.Context context) {
            return new BaseProgressIndicator(){

                public void progress() {
                    super.progress();
                    context.progress();
                }
            };
        }

        private File persist(IncrementalIndex index, Interval interval, File file, ProgressIndicator progressIndicator) throws IOException {
            if (this.config.isBuildV9Directly()) {
                return HadoopDruidIndexerConfig.INDEX_MERGER_V9.persist(index, interval, file, this.config.getIndexSpec(), progressIndicator);
            }
            return HadoopDruidIndexerConfig.INDEX_MERGER.persist(index, interval, file, this.config.getIndexSpec(), progressIndicator);
        }

        protected File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] aggs, File file, ProgressIndicator progressIndicator) throws IOException {
            boolean rollup = this.config.getSchema().getDataSchema().getGranularitySpec().isRollup();
            if (this.config.isBuildV9Directly()) {
                return HadoopDruidIndexerConfig.INDEX_MERGER_V9.mergeQueryableIndex(indexes, rollup, aggs, file, this.config.getIndexSpec(), progressIndicator);
            }
            return HadoopDruidIndexerConfig.INDEX_MERGER.mergeQueryableIndex(indexes, rollup, aggs, file, this.config.getIndexSpec(), progressIndicator);
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            this.aggregators = this.config.getSchema().getDataSchema().getAggregators();
            this.combiningAggs = new AggregatorFactory[this.aggregators.length];
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.metricNames.add(this.aggregators[i].getName());
                this.combiningAggs[i] = this.aggregators[i].getCombiningFactory();
            }
        }

        protected void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            SortableBytes keyBytes = SortableBytes.fromBytesWritable(key);
            Bucket bucket = (Bucket)Bucket.fromGroupKey((byte[])keyBytes.getGroupKey()).lhs;
            final Interval interval = (Interval)this.config.getGranularitySpec().bucketInterval(bucket.time).get();
            ListeningExecutorService persistExecutor = null;
            ArrayList persistFutures = Lists.newArrayList();
            IncrementalIndex index = IndexGeneratorJob.makeIncrementalIndex(bucket, this.combiningAggs, this.config, null, null);
            try {
                File mergedBase;
                File baseFlushFile = File.createTempFile("base", "flush");
                baseFlushFile.delete();
                baseFlushFile.mkdirs();
                TreeSet toMerge = Sets.newTreeSet();
                int indexCount = 0;
                int lineCount = 0;
                int runningTotalLineCount = 0;
                long startTime = System.currentTimeMillis();
                LinkedHashSet allDimensionNames = Sets.newLinkedHashSet();
                final ProgressIndicator progressIndicator = this.makeProgressIndicator(context);
                int numBackgroundPersistThreads = this.config.getSchema().getTuningConfig().getNumBackgroundPersistThreads();
                if (numBackgroundPersistThreads > 0) {
                    SynchronousQueue queue = new SynchronousQueue();
                    ThreadPoolExecutor executorService = new ThreadPoolExecutor(numBackgroundPersistThreads, numBackgroundPersistThreads, 0L, TimeUnit.MILLISECONDS, queue, Execs.makeThreadFactory((String)"IndexGeneratorJob_persist_%d"), new RejectedExecutionHandler(){

                        @Override
                        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                            try {
                                executor.getQueue().put(r);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new RejectedExecutionException("Got Interrupted while adding to the Queue");
                            }
                        }
                    });
                    persistExecutor = MoreExecutors.listeningDecorator((ExecutorService)executorService);
                } else {
                    persistExecutor = MoreExecutors.sameThreadExecutor();
                }
                for (BytesWritable bw : values) {
                    context.progress();
                    InputRow inputRow = index.formatRow(InputRowSerde.fromBytes(bw.getBytes(), this.aggregators));
                    int numRows = index.add(inputRow);
                    ++lineCount;
                    if (index.canAppendRow()) continue;
                    allDimensionNames.addAll(index.getDimensionOrder());
                    log.info(index.getOutOfRowsReason(), new Object[0]);
                    log.info("%,d lines to %,d rows in %,d millis", new Object[]{lineCount - runningTotalLineCount, numRows, System.currentTimeMillis() - startTime});
                    runningTotalLineCount = lineCount;
                    final File file = new File(baseFlushFile, String.format("index%,05d", indexCount));
                    toMerge.add(file);
                    context.progress();
                    final IncrementalIndex persistIndex = index;
                    persistFutures.add(persistExecutor.submit((Runnable)new ThreadRenamingRunnable(String.format("%s-persist", file.getName())){

                        public void doRun() {
                            try {
                                IndexGeneratorReducer.this.persist(persistIndex, interval, file, progressIndicator);
                            }
                            catch (Exception e) {
                                log.error((Throwable)e, "persist index error", new Object[0]);
                                throw Throwables.propagate((Throwable)e);
                            }
                            finally {
                                persistIndex.close();
                            }
                        }
                    }));
                    index = IndexGeneratorJob.makeIncrementalIndex(bucket, this.combiningAggs, this.config, allDimensionNames, persistIndex.getColumnCapabilities());
                    startTime = System.currentTimeMillis();
                    ++indexCount;
                }
                allDimensionNames.addAll(index.getDimensionOrder());
                log.info("%,d lines completed.", new Object[]{lineCount});
                ArrayList indexes = Lists.newArrayListWithCapacity((int)indexCount);
                if (toMerge.size() == 0) {
                    if (index.isEmpty()) {
                        throw new IAE("If you try to persist empty indexes you are going to have a bad time", new Object[0]);
                    }
                    mergedBase = new File(baseFlushFile, "merged");
                    this.persist(index, interval, mergedBase, progressIndicator);
                } else {
                    if (!index.isEmpty()) {
                        File finalFile = new File(baseFlushFile, "final");
                        this.persist(index, interval, finalFile, progressIndicator);
                        toMerge.add(finalFile);
                    }
                    Futures.allAsList((Iterable)persistFutures).get(1L, TimeUnit.HOURS);
                    persistExecutor.shutdown();
                    for (File file : toMerge) {
                        indexes.add(HadoopDruidIndexerConfig.INDEX_IO.loadIndex(file));
                    }
                    mergedBase = this.mergeQueryableIndex(indexes, this.aggregators, new File(baseFlushFile, "merged"), progressIndicator);
                }
                FileSystem outputFS = new Path(this.config.getSchema().getIOConfig().getSegmentOutputPath()).getFileSystem(context.getConfiguration());
                ShardSpec shardSpecForPartitioning = this.config.getShardSpec(bucket).getActualSpec();
                Object shardSpecForPublishing = this.config.isForceExtendableShardSpecs() ? new NumberedShardSpec(shardSpecForPartitioning.getPartitionNum(), this.config.getShardSpecCount(bucket)) : shardSpecForPartitioning;
                DataSegment segmentTemplate = new DataSegment(this.config.getDataSource(), interval, this.config.getSchema().getTuningConfig().getVersion(), null, (List)ImmutableList.copyOf((Collection)allDimensionNames), this.metricNames, shardSpecForPublishing, Integer.valueOf(-1), -1L);
                DataSegment segment = JobHelper.serializeOutIndex(segmentTemplate, context.getConfiguration(), (Progressable)context, context.getTaskAttemptID(), mergedBase, JobHelper.makeSegmentOutputPath(new Path(this.config.getSchema().getIOConfig().getSegmentOutputPath()), outputFS, segmentTemplate));
                Path descriptorPath = this.config.makeDescriptorInfoPath(segment);
                descriptorPath = JobHelper.prependFSIfNullScheme(FileSystem.get((URI)descriptorPath.toUri(), (Configuration)context.getConfiguration()), descriptorPath);
                log.info("Writing descriptor to path[%s]", new Object[]{descriptorPath});
                JobHelper.writeSegmentDescriptor(this.config.makeDescriptorInfoDir().getFileSystem(context.getConfiguration()), segment, descriptorPath, (Progressable)context);
                for (File file : toMerge) {
                    FileUtils.deleteDirectory((File)file);
                }
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (TimeoutException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                index.close();
                if (persistExecutor != null) {
                    persistExecutor.shutdownNow();
                }
            }
        }
    }

    public static class IndexGeneratorPartitioner
    extends Partitioner<BytesWritable, Writable>
    implements Configurable {
        private Configuration config;

        public int getPartition(BytesWritable bytesWritable, Writable value, int numPartitions) {
            ByteBuffer bytes = ByteBuffer.wrap(bytesWritable.getBytes());
            bytes.position(4);
            int shardNum = bytes.getInt();
            if (this.config.get("mapred.job.tracker").equals("local")) {
                return shardNum % numPartitions;
            }
            if (shardNum >= numPartitions) {
                throw new ISE("Not enough partitions, shard[%,d] >= numPartitions[%,d]", new Object[]{shardNum, numPartitions});
            }
            return shardNum;
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
        }
    }

    public static class IndexGeneratorCombiner
    extends Reducer<BytesWritable, BytesWritable, BytesWritable, BytesWritable> {
        private HadoopDruidIndexerConfig config;
        private AggregatorFactory[] aggregators;
        private AggregatorFactory[] combiningAggs;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            this.aggregators = this.config.getSchema().getDataSchema().getAggregators();
            this.combiningAggs = new AggregatorFactory[this.aggregators.length];
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.combiningAggs[i] = this.aggregators[i].getCombiningFactory();
            }
        }

        protected void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<BytesWritable> iter = values.iterator();
            BytesWritable first = iter.next();
            if (iter.hasNext()) {
                LinkedHashSet dimOrder = Sets.newLinkedHashSet();
                SortableBytes keyBytes = SortableBytes.fromBytesWritable(key);
                Bucket bucket = (Bucket)Bucket.fromGroupKey((byte[])keyBytes.getGroupKey()).lhs;
                IncrementalIndex index = IndexGeneratorJob.makeIncrementalIndex(bucket, this.combiningAggs, this.config, null, null);
                index.add(InputRowSerde.fromBytes(first.getBytes(), this.aggregators));
                while (iter.hasNext()) {
                    context.progress();
                    InputRow value = InputRowSerde.fromBytes(iter.next().getBytes(), this.aggregators);
                    if (!index.canAppendRow()) {
                        dimOrder.addAll(index.getDimensionOrder());
                        log.info("current index full due to [%s]. creating new index.", new Object[]{index.getOutOfRowsReason()});
                        this.flushIndexToContextAndClose(key, index, context);
                        index = IndexGeneratorJob.makeIncrementalIndex(bucket, this.combiningAggs, this.config, dimOrder, index.getColumnCapabilities());
                    }
                    index.add(value);
                }
                this.flushIndexToContextAndClose(key, index, context);
            } else {
                context.write((Object)key, (Object)first);
            }
        }

        private void flushIndexToContextAndClose(BytesWritable key, IncrementalIndex index, Reducer.Context context) throws IOException, InterruptedException {
            List dimensions = index.getDimensionNames();
            Iterator rows = index.iterator();
            while (rows.hasNext()) {
                context.progress();
                Row row = (Row)rows.next();
                InputRow inputRow = this.getInputRowFromRow(row, dimensions);
                context.write((Object)key, (Object)new BytesWritable(InputRowSerde.toBytes(inputRow, this.combiningAggs, true)));
            }
            index.close();
        }

        private InputRow getInputRowFromRow(final Row row, final List<String> dimensions) {
            return new InputRow(){

                public List<String> getDimensions() {
                    return dimensions;
                }

                public long getTimestampFromEpoch() {
                    return row.getTimestampFromEpoch();
                }

                public DateTime getTimestamp() {
                    return row.getTimestamp();
                }

                public List<String> getDimension(String dimension) {
                    return row.getDimension(dimension);
                }

                public Object getRaw(String dimension) {
                    return row.getRaw(dimension);
                }

                public float getFloatMetric(String metric) {
                    return row.getFloatMetric(metric);
                }

                public long getLongMetric(String metric) {
                    return row.getLongMetric(metric);
                }

                public int compareTo(Row o) {
                    return row.compareTo((Object)o);
                }
            };
        }
    }

    public static class IndexGeneratorMapper
    extends HadoopDruidIndexerMapper<BytesWritable, BytesWritable> {
        private static final HashFunction hashFunction = Hashing.murmur3_128();
        private AggregatorFactory[] aggregators;
        private AggregatorFactory[] combiningAggs;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.aggregators = this.config.getSchema().getDataSchema().getAggregators();
            this.combiningAggs = new AggregatorFactory[this.aggregators.length];
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.combiningAggs[i] = this.aggregators[i].getCombiningFactory();
            }
        }

        @Override
        protected void innerMap(InputRow inputRow, Object value, Mapper.Context context, boolean reportParseExceptions) throws IOException, InterruptedException {
            Optional<Bucket> bucket = this.getConfig().getBucket(inputRow);
            if (!bucket.isPresent()) {
                throw new ISE("WTF?! No bucket found for row: %s", new Object[]{inputRow});
            }
            long truncatedTimestamp = this.granularitySpec.getQueryGranularity().truncate(inputRow.getTimestampFromEpoch());
            byte[] hashedDimensions = hashFunction.hashBytes(HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsBytes((Object)Rows.toGroupKey((long)truncatedTimestamp, (InputRow)inputRow))).asBytes();
            byte[] serializedInputRow = inputRow instanceof SegmentInputRow ? InputRowSerde.toBytes(inputRow, this.combiningAggs, reportParseExceptions) : InputRowSerde.toBytes(inputRow, this.aggregators, reportParseExceptions);
            context.write((Object)new SortableBytes(((Bucket)bucket.get()).toGroupKey(new byte[0][]), ByteBuffer.allocate(8 + hashedDimensions.length).putLong(truncatedTimestamp).put(hashedDimensions).array()).toBytesWritable(), (Object)new BytesWritable(serializedInputRow));
        }
    }
}

