/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.hadoop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.common.utils.JodaUtils;
import io.druid.granularity.QueryGranularities;
import io.druid.granularity.QueryGranularity;
import io.druid.query.filter.DimFilter;
import io.druid.timeline.DataSegment;
import java.util.List;
import org.joda.time.Interval;

public class DatasourceIngestionSpec {
    private final String dataSource;
    private final List<Interval> intervals;
    private final List<DataSegment> segments;
    private final DimFilter filter;
    private final QueryGranularity granularity;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final boolean ignoreWhenNoSegments;

    @JsonCreator
    public DatasourceIngestionSpec(@JsonProperty(value="dataSource") String dataSource, @Deprecated @JsonProperty(value="interval") Interval interval, @JsonProperty(value="intervals") List<Interval> intervals, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="filter") DimFilter filter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="ignoreWhenNoSegments") boolean ignoreWhenNoSegments) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"null dataSource");
        Preconditions.checkArgument((interval == null || intervals == null ? 1 : 0) != 0, (Object)"please specify intervals only");
        Object theIntervals = null;
        if (interval != null) {
            theIntervals = ImmutableList.of((Object)interval);
        } else if (intervals != null && intervals.size() > 0) {
            theIntervals = JodaUtils.condenseIntervals(intervals);
        }
        this.intervals = (List)Preconditions.checkNotNull((Object)theIntervals, (Object)"no intervals found");
        this.segments = segments;
        this.filter = filter;
        this.granularity = granularity == null ? QueryGranularities.NONE : granularity;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.ignoreWhenNoSegments = ignoreWhenNoSegments;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public boolean isIgnoreWhenNoSegments() {
        return this.ignoreWhenNoSegments;
    }

    public DatasourceIngestionSpec withDimensions(List<String> dimensions) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.granularity, dimensions, this.metrics, this.ignoreWhenNoSegments);
    }

    public DatasourceIngestionSpec withMetrics(List<String> metrics) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.granularity, this.dimensions, metrics, this.ignoreWhenNoSegments);
    }

    public DatasourceIngestionSpec withQueryGranularity(QueryGranularity granularity) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, granularity, this.dimensions, this.metrics, this.ignoreWhenNoSegments);
    }

    public DatasourceIngestionSpec withIgnoreWhenNoSegments(boolean ignoreWhenNoSegments) {
        return new DatasourceIngestionSpec(this.dataSource, null, this.intervals, this.segments, this.filter, this.granularity, this.dimensions, this.metrics, ignoreWhenNoSegments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasourceIngestionSpec that = (DatasourceIngestionSpec)o;
        if (this.ignoreWhenNoSegments != that.ignoreWhenNoSegments) {
            return false;
        }
        if (!this.dataSource.equals(that.dataSource)) {
            return false;
        }
        if (!this.intervals.equals(that.intervals)) {
            return false;
        }
        if (this.segments != null ? !this.segments.equals(that.segments) : that.segments != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (!this.granularity.equals(that.granularity)) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) {
            return false;
        }
        return !(this.metrics == null ? that.metrics != null : !this.metrics.equals(that.metrics));
    }

    public int hashCode() {
        int result = this.dataSource.hashCode();
        result = 31 * result + this.intervals.hashCode();
        result = 31 * result + (this.segments != null ? this.segments.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + this.granularity.hashCode();
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
        result = 31 * result + (this.ignoreWhenNoSegments ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DatasourceIngestionSpec{dataSource='" + this.dataSource + '\'' + ", intervals=" + this.intervals + ", segments=" + this.segments + ", filter=" + this.filter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", ignoreWhenNoSegments=" + this.ignoreWhenNoSegments + '}';
    }
}

