/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.appenderator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.java.util.common.JodaUtils;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.Interval;

public class ActionBasedUsedSegmentChecker
implements UsedSegmentChecker {
    private final TaskActionClient taskActionClient;

    public ActionBasedUsedSegmentChecker(TaskActionClient taskActionClient) {
        this.taskActionClient = taskActionClient;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdentifier> identifiers) throws IOException {
        TreeMap identifiersByDataSource = Maps.newTreeMap();
        for (SegmentIdentifier identifier : identifiers) {
            if (!identifiersByDataSource.containsKey(identifier.getDataSource())) {
                identifiersByDataSource.put(identifier.getDataSource(), Sets.newHashSet());
            }
            ((Set)identifiersByDataSource.get(identifier.getDataSource())).add(identifier);
        }
        HashSet retVal = Sets.newHashSet();
        for (Map.Entry entry : identifiersByDataSource.entrySet()) {
            ArrayList intervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform((Iterable)((Iterable)entry.getValue()), (Function)new Function<SegmentIdentifier, Interval>(){

                public Interval apply(SegmentIdentifier input) {
                    return input.getInterval();
                }
            }));
            List<DataSegment> usedSegmentsForIntervals = this.taskActionClient.submit(new SegmentListUsedAction((String)entry.getKey(), null, intervals));
            for (DataSegment segment : usedSegmentsForIntervals) {
                if (!identifiers.contains(SegmentIdentifier.fromDataSegment((DataSegment)segment))) continue;
                retVal.add(segment);
            }
        }
        return retVal;
    }
}

