/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import io.druid.indexing.common.RetryPolicyConfig;
import org.joda.time.Duration;

public class RetryPolicy {
    private final long maxNumRetries;
    private final Duration maxRetryDelay;
    private Duration currRetryDelay;
    private int retryCount;

    public RetryPolicy(RetryPolicyConfig config) {
        this.maxNumRetries = config.getMaxRetryCount();
        this.maxRetryDelay = config.getMaxWait().toStandardDuration();
        this.currRetryDelay = config.getMinWait().toStandardDuration();
        this.retryCount = 0;
    }

    public Duration getAndIncrementRetryDelay() {
        if (this.hasExceededRetryThreshold()) {
            return null;
        }
        Duration retVal = this.currRetryDelay;
        this.currRetryDelay = new Duration(Math.min(this.currRetryDelay.getMillis() * 2L, this.maxRetryDelay.getMillis()));
        ++this.retryCount;
        return retVal;
    }

    public boolean hasExceededRetryThreshold() {
        return (long)this.retryCount >= this.maxNumRetries;
    }
}

