/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.inject.Provider;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.discovery.DataNodeService;
import io.druid.discovery.DruidNodeAnnouncer;
import io.druid.discovery.LookupNodeService;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.metrics.MonitorScheduler;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.DruidNode;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentServerAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class TaskToolbox {
    private final TaskConfig config;
    private final TaskActionClient taskActionClient;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final MonitorScheduler monitorScheduler;
    private final ExecutorService queryExecutorService;
    private final SegmentLoader segmentLoader;
    private final ObjectMapper objectMapper;
    private final File taskWorkDir;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final IndexMergerV9 indexMergerV9;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;

    public TaskToolbox(TaskConfig config, TaskActionClient taskActionClient, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoader segmentLoader, ObjectMapper objectMapper, File taskWorkDir, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService) {
        this.config = config;
        this.taskActionClient = taskActionClient;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoader = segmentLoader;
        this.objectMapper = objectMapper;
        this.taskWorkDir = taskWorkDir;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClient;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public DataSegmentServerAnnouncer getDataSegmentServerAnnouncer() {
        return this.serverAnnouncer;
    }

    public SegmentHandoffNotifierFactory getSegmentHandoffNotifierFactory() {
        return this.handoffNotifierFactory;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return (QueryRunnerFactoryConglomerate)this.queryRunnerFactoryConglomerateProvider.get();
    }

    public ExecutorService getQueryExecutorService() {
        return this.queryExecutorService;
    }

    public MonitorScheduler getMonitorScheduler() {
        return this.monitorScheduler;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) throws SegmentLoadingException {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (DataSegment segment : segments) {
            retVal.put(segment, this.segmentLoader.getSegmentFiles(segment));
        }
        return retVal;
    }

    public void publishSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, (Function)new Function<DataSegment, Interval>(){

            public Interval apply(DataSegment segment) {
                return segment.getInterval();
            }
        });
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(new SegmentInsertAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection)));
        }
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public IndexMergerV9 getIndexMergerV9() {
        return this.indexMergerV9;
    }

    public File getFirehoseTemporaryDir() {
        return new File(this.taskWorkDir, "firehose");
    }

    public File getMergeDir() {
        return new File(this.taskWorkDir, "merge");
    }

    public File getPersistDir() {
        return new File(this.taskWorkDir, "persist");
    }

    public DruidNodeAnnouncer getDruidNodeAnnouncer() {
        return this.druidNodeAnnouncer;
    }

    public LookupNodeService getLookupNodeService() {
        return this.lookupNodeService;
    }

    public DataNodeService getDataNodeService() {
        return this.dataNodeService;
    }

    public DruidNode getDruidNode() {
        return this.druidNode;
    }
}

