/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.discovery.DataNodeService;
import io.druid.discovery.DruidNodeAnnouncer;
import io.druid.discovery.LookupNodeService;
import io.druid.guice.annotations.Processing;
import io.druid.guice.annotations.RemoteChatHandler;
import io.druid.indexing.common.SegmentLoaderFactory;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.metrics.MonitorScheduler;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.DruidNode;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentServerAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;

public class TaskToolboxFactory {
    private final TaskConfig config;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final ExecutorService queryExecutorService;
    private final MonitorScheduler monitorScheduler;
    private final SegmentLoaderFactory segmentLoaderFactory;
    private final ObjectMapper objectMapper;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final IndexMergerV9 indexMergerV9;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;

    @Inject
    public TaskToolboxFactory(TaskConfig config, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, @Processing ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoaderFactory segmentLoaderFactory, ObjectMapper objectMapper, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, @RemoteChatHandler DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService) {
        this.config = config;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoaderFactory = segmentLoaderFactory;
        this.objectMapper = objectMapper;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.indexMergerV9 = indexMergerV9;
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
    }

    public TaskToolbox build(Task task) {
        File taskWorkDir = this.config.getTaskWorkDir(task.getId());
        return new TaskToolbox(this.config, this.taskActionClientFactory.create(task), this.emitter, this.segmentPusher, this.dataSegmentKiller, this.dataSegmentMover, this.dataSegmentArchiver, this.segmentAnnouncer, this.serverAnnouncer, this.handoffNotifierFactory, this.queryRunnerFactoryConglomerateProvider, this.queryExecutorService, this.monitorScheduler, this.segmentLoaderFactory.manufacturate(taskWorkDir), this.objectMapper, taskWorkDir, this.indexIO, this.cache, this.cacheConfig, this.indexMergerV9, this.druidNodeAnnouncer, this.druidNode, this.lookupNodeService, this.dataNodeService);
    }
}

