/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.DataSourceMetadata;
import java.io.IOException;

public class CheckPointDataSourceMetadataAction
implements TaskAction<Boolean> {
    private final String supervisorId;
    private final String sequenceName;
    private final DataSourceMetadata previousCheckPoint;
    private final DataSourceMetadata currentCheckPoint;

    public CheckPointDataSourceMetadataAction(@JsonProperty(value="supervisorId") String supervisorId, @JsonProperty(value="sequenceName") String sequenceName, @JsonProperty(value="previousCheckPoint") DataSourceMetadata previousCheckPoint, @JsonProperty(value="currentCheckPoint") DataSourceMetadata currentCheckPoint) {
        this.supervisorId = supervisorId;
        this.sequenceName = sequenceName;
        this.previousCheckPoint = previousCheckPoint;
        this.currentCheckPoint = currentCheckPoint;
    }

    @JsonProperty
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @JsonProperty
    public String getSequenceName() {
        return this.sequenceName;
    }

    @JsonProperty
    public DataSourceMetadata getPreviousCheckPoint() {
        return this.previousCheckPoint;
    }

    @JsonProperty
    public DataSourceMetadata getCurrentCheckPoint() {
        return this.currentCheckPoint;
    }

    @Override
    public TypeReference<Boolean> getReturnTypeReference() {
        return new TypeReference<Boolean>(){};
    }

    @Override
    public Boolean perform(Task task, TaskActionToolbox toolbox) throws IOException {
        return toolbox.getSupervisorManager().checkPointDataSourceMetadata(this.supervisorId, this.sequenceName, this.previousCheckPoint, this.currentCheckPoint);
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "CheckPointDataSourceMetadataAction{supervisorId='" + this.supervisorId + '\'' + ", sequenceName='" + this.sequenceName + '\'' + ", previousCheckPoint=" + this.previousCheckPoint + ", currentCheckPoint=" + this.currentCheckPoint + '}';
    }
}

