/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.java.util.common.ISE;
import io.druid.java.util.emitter.EmittingLogger;
import java.io.IOException;

public class LocalTaskActionClient
implements TaskActionClient {
    private final Task task;
    private final TaskStorage storage;
    private final TaskActionToolbox toolbox;
    private static final EmittingLogger log = new EmittingLogger(LocalTaskActionClient.class);

    public LocalTaskActionClient(Task task, TaskStorage storage, TaskActionToolbox toolbox) {
        this.task = task;
        this.storage = storage;
        this.toolbox = toolbox;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) throws IOException {
        log.info("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        if (taskAction.isAudited()) {
            try {
                this.storage.addAuditLog(this.task, taskAction);
            }
            catch (Exception e) {
                String actionClass = taskAction.getClass().getName();
                log.makeAlert((Throwable)e, "Failed to record action in audit log", new Object[0]).addData("task", (Object)this.task.getId()).addData("actionClass", (Object)actionClass).emit();
                throw new ISE((Throwable)e, "Failed to record action [%s] in audit log", new Object[]{actionClass});
            }
        }
        return taskAction.perform(this.task, this.toolbox);
    }
}

