/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskLockType;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.LockResult;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class LockAcquireAction
implements TaskAction<TaskLock> {
    private final TaskLockType type;
    @JsonIgnore
    private final Interval interval;
    @JsonIgnore
    private final long timeoutMs;

    @JsonCreator
    public LockAcquireAction(@JsonProperty(value="lockType") @Nullable TaskLockType type, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="timeoutMs") long timeoutMs) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.timeoutMs = timeoutMs;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        try {
            LockResult result = this.timeoutMs == 0L ? toolbox.getTaskLockbox().lock(this.type, task, this.interval) : toolbox.getTaskLockbox().lock(this.type, task, this.interval, this.timeoutMs);
            return result.isOk() ? result.getTaskLock() : null;
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public String toString() {
        return "LockAcquireAction{lockType=" + (Object)((Object)this.type) + ", interval=" + this.interval + ", timeoutMs=" + this.timeoutMs + '}';
    }
}

