/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskLockType;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.LockResult;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class LockTryAcquireAction
implements TaskAction<TaskLock> {
    @JsonIgnore
    private final TaskLockType type;
    @JsonIgnore
    private final Interval interval;

    @JsonCreator
    public LockTryAcquireAction(@JsonProperty(value="lockType") @Nullable TaskLockType type, @JsonProperty(value="interval") Interval interval) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.interval = interval;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        LockResult result = toolbox.getTaskLockbox().tryLock(this.type, task, this.interval);
        return result.isOk() ? result.getTaskLock() : null;
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public String toString() {
        return "LockTryAcquireAction{lockType=" + (Object)((Object)this.type) + ", interval=" + this.interval + '}';
    }
}

