/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.client.indexing.IndexingService;
import io.druid.discovery.DruidLeaderClient;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.actions.RemoteTaskActionClient;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;

public class RemoteTaskActionClientFactory
implements TaskActionClientFactory {
    private final DruidLeaderClient druidLeaderClient;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public RemoteTaskActionClientFactory(@IndexingService DruidLeaderClient leaderHttpClient, RetryPolicyFactory retryPolicyFactory, ObjectMapper jsonMapper) {
        this.druidLeaderClient = leaderHttpClient;
        this.retryPolicyFactory = retryPolicyFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TaskActionClient create(Task task) {
        return new RemoteTaskActionClient(task, this.druidLeaderClient, this.retryPolicyFactory, this.jsonMapper);
    }
}

