/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.DataSourceMetadata;
import java.io.IOException;

public class ResetDataSourceMetadataAction
implements TaskAction<Boolean> {
    private final String dataSource;
    private final DataSourceMetadata resetMetadata;

    public ResetDataSourceMetadataAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="resetMetadata") DataSourceMetadata resetMetadata) {
        this.dataSource = dataSource;
        this.resetMetadata = resetMetadata;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public DataSourceMetadata getResetMetadata() {
        return this.resetMetadata;
    }

    @Override
    public TypeReference<Boolean> getReturnTypeReference() {
        return new TypeReference<Boolean>(){};
    }

    @Override
    public Boolean perform(Task task, TaskActionToolbox toolbox) throws IOException {
        return toolbox.getSupervisorManager().resetSupervisor(this.dataSource, this.resetMetadata);
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "ResetDataSourceMetadataAction{dataSource='" + this.dataSource + '\'' + ", resetMetadata=" + this.resetMetadata + '}';
    }
}

