/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionPreconditions;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.CriticalAction;
import io.druid.java.util.common.ISE;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.Interval;

public class SegmentMetadataUpdateAction
implements TaskAction<Void> {
    @JsonIgnore
    private final Set<DataSegment> segments;

    @JsonCreator
    public SegmentMetadataUpdateAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) throws IOException {
        TaskActionPreconditions.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        List<Interval> intervals = this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toList());
        try {
            toolbox.getTaskLockbox().doInCriticalSection(task, intervals, CriticalAction.builder().onValidLocks(() -> {
                toolbox.getIndexerMetadataStorageCoordinator().updateSegmentMetadata(this.segments);
                return null;
            }).onInvalidLocks(() -> {
                throw new ISE("Some locks for task[%s] are already revoked", new Object[]{task.getId()});
            }).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder().setDimension("dataSource", task.getDataSource()).setDimension("taskType", task.getType());
        for (DataSegment segment : this.segments) {
            metricBuilder.setDimension("interval", segment.getInterval().toString());
            toolbox.getEmitter().emit(metricBuilder.build("segment/moved/bytes", (Number)segment.getSize()));
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "SegmentMetadataUpdateAction{segments=" + this.segments + '}';
    }
}

